/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.models;

import dev.xf3d3.ultimatereports.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class Position {
    @Expose
    private double x;
    @Expose
    private double y;
    @Expose
    private double z;
    @Expose
    private String world;
    @Expose
    private float yaw;
    @Expose
    private float pitch;
    @Expose
    @Nullable
    private String server;

    protected Position(double x, double y, double z, @NotNull String world, float yaw, float pitch, @Nullable String server) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.yaw = yaw;
        this.pitch = pitch;
        this.server = server;
    }

    private Position() {
    }

    @NotNull
    public static Position at(double x, double y, double z, @NotNull String world, float yaw, float pitch, @Nullable String server) {
        return new Position(x, y, z, world, yaw, pitch, server);
    }

    @NotNull
    public static Position at(Location location, @Nullable String server) {
        return new Position(location.getX(), location.getY(), location.getZ(), location.getWorld().getName(), location.getYaw(), location.getPitch(), server);
    }

    public Location getLocation() {
        return new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Generated
    public String getWorld() {
        return this.world;
    }

    @Generated
    public void setWorld(String world) {
        this.world = world;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Nullable
    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public void setServer(@Nullable String server) {
        this.server = server;
    }
}

