/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.models;

import com.google.common.collect.Lists;
import dev.xf3d3.ultimatereports.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimatereports.libraries.gson.annotations.SerializedName;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.ApiStatus;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.Position;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Report {
    private int id;
    @Expose
    private long timestamp;
    @Expose
    @SerializedName(value="reporter_uuid")
    private UUID reporter;
    @Expose
    @SerializedName(value="reported_uuid")
    private UUID reported;
    @Expose
    @SerializedName(value="reporter_name")
    private String reporterName;
    @Expose
    @SerializedName(value="reported_name")
    private String reportedName;
    @Expose
    private String reason;
    @Expose
    private Status status;
    @Expose
    private MarkedAs markedAs;
    @Expose
    @SerializedName(value="reporter_position")
    private Position reporterPosition;
    @Expose
    @SerializedName(value="reported_position")
    @Nullable
    private Position reportedPosition;
    @Expose
    @SerializedName(value="discord_message_id")
    @Nullable
    private String discordMessageId;
    @Expose
    private List<Comment> comments;

    @NotNull
    @ApiStatus.Internal
    public static Report create(@NotNull Player reporter, @NotNull OfflinePlayer reported, @NotNull String reason, @NotNull Position reporterPosition, @Nullable Position reportedPosition) {
        return Report.builder().reported(reported.getUniqueId()).reporter(reporter.getUniqueId()).reporterName(reporter.getName()).reportedName(reported.getName()).reason(reason).reporterPosition(reporterPosition).reportedPosition(reportedPosition).build();
    }

    public void addOrUpdateComment(@NotNull Comment comment) {
        int index = this.comments.indexOf(comment);
        if (index >= 0) {
            this.comments.set(index, comment);
        } else {
            this.comments.add(comment);
        }
    }

    public Optional<Comment> getComment(@NotNull UUID uuid) {
        return this.comments.stream().filter(c -> c.getId().equals(uuid)).findFirst();
    }

    public void removeComment(@NotNull UUID commentId) {
        this.comments.removeIf(c -> c.getId().equals(commentId));
    }

    @Generated
    private static int $default$id() {
        return 0;
    }

    @Generated
    private static long $default$timestamp() {
        return System.currentTimeMillis();
    }

    @Generated
    private static Status $default$status() {
        return Status.WAITING;
    }

    @Generated
    private static List<Comment> $default$comments() {
        return Lists.newCopyOnWriteArrayList();
    }

    @Generated
    public static ReportBuilder builder() {
        return new ReportBuilder();
    }

    @Generated
    private Report() {
        this.id = Report.$default$id();
        this.timestamp = Report.$default$timestamp();
        this.status = Report.$default$status();
        this.comments = Report.$default$comments();
    }

    @Generated
    private Report(int id, long timestamp, UUID reporter, UUID reported, String reporterName, String reportedName, String reason, Status status, MarkedAs markedAs, Position reporterPosition, @Nullable Position reportedPosition, @Nullable String discordMessageId, List<Comment> comments) {
        this.id = id;
        this.timestamp = timestamp;
        this.reporter = reporter;
        this.reported = reported;
        this.reporterName = reporterName;
        this.reportedName = reportedName;
        this.reason = reason;
        this.status = status;
        this.markedAs = markedAs;
        this.reporterPosition = reporterPosition;
        this.reportedPosition = reportedPosition;
        this.discordMessageId = discordMessageId;
        this.comments = comments;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public UUID getReporter() {
        return this.reporter;
    }

    @Generated
    public void setReporter(UUID reporter) {
        this.reporter = reporter;
    }

    @Generated
    public UUID getReported() {
        return this.reported;
    }

    @Generated
    public void setReported(UUID reported) {
        this.reported = reported;
    }

    @Generated
    public String getReporterName() {
        return this.reporterName;
    }

    @Generated
    public void setReporterName(String reporterName) {
        this.reporterName = reporterName;
    }

    @Generated
    public String getReportedName() {
        return this.reportedName;
    }

    @Generated
    public void setReportedName(String reportedName) {
        this.reportedName = reportedName;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public MarkedAs getMarkedAs() {
        return this.markedAs;
    }

    @Generated
    public void setMarkedAs(MarkedAs markedAs) {
        this.markedAs = markedAs;
    }

    @Generated
    public Position getReporterPosition() {
        return this.reporterPosition;
    }

    @Generated
    public void setReporterPosition(Position reporterPosition) {
        this.reporterPosition = reporterPosition;
    }

    @Nullable
    @Generated
    public Position getReportedPosition() {
        return this.reportedPosition;
    }

    @Generated
    public void setReportedPosition(@Nullable Position reportedPosition) {
        this.reportedPosition = reportedPosition;
    }

    @Nullable
    @Generated
    public String getDiscordMessageId() {
        return this.discordMessageId;
    }

    @Generated
    public void setDiscordMessageId(@Nullable String discordMessageId) {
        this.discordMessageId = discordMessageId;
    }

    @Generated
    public List<Comment> getComments() {
        return this.comments;
    }

    @Generated
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @Generated
    public static class ReportBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private int id$value;
        @Generated
        private boolean timestamp$set;
        @Generated
        private long timestamp$value;
        @Generated
        private UUID reporter;
        @Generated
        private UUID reported;
        @Generated
        private String reporterName;
        @Generated
        private String reportedName;
        @Generated
        private String reason;
        @Generated
        private boolean status$set;
        @Generated
        private Status status$value;
        @Generated
        private MarkedAs markedAs;
        @Generated
        private Position reporterPosition;
        @Generated
        private Position reportedPosition;
        @Generated
        private String discordMessageId;
        @Generated
        private boolean comments$set;
        @Generated
        private List<Comment> comments$value;

        @Generated
        ReportBuilder() {
        }

        @Generated
        public ReportBuilder id(int id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public ReportBuilder timestamp(long timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        @Generated
        public ReportBuilder reporter(UUID reporter) {
            this.reporter = reporter;
            return this;
        }

        @Generated
        public ReportBuilder reported(UUID reported) {
            this.reported = reported;
            return this;
        }

        @Generated
        public ReportBuilder reporterName(String reporterName) {
            this.reporterName = reporterName;
            return this;
        }

        @Generated
        public ReportBuilder reportedName(String reportedName) {
            this.reportedName = reportedName;
            return this;
        }

        @Generated
        public ReportBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Generated
        public ReportBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public ReportBuilder markedAs(MarkedAs markedAs) {
            this.markedAs = markedAs;
            return this;
        }

        @Generated
        public ReportBuilder reporterPosition(Position reporterPosition) {
            this.reporterPosition = reporterPosition;
            return this;
        }

        @Generated
        public ReportBuilder reportedPosition(@Nullable Position reportedPosition) {
            this.reportedPosition = reportedPosition;
            return this;
        }

        @Generated
        public ReportBuilder discordMessageId(@Nullable String discordMessageId) {
            this.discordMessageId = discordMessageId;
            return this;
        }

        @Generated
        public ReportBuilder comments(List<Comment> comments) {
            this.comments$value = comments;
            this.comments$set = true;
            return this;
        }

        @Generated
        public Report build() {
            int id$value = this.id$value;
            if (!this.id$set) {
                id$value = Report.$default$id();
            }
            long timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = Report.$default$timestamp();
            }
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = Report.$default$status();
            }
            List<Comment> comments$value = this.comments$value;
            if (!this.comments$set) {
                comments$value = Report.$default$comments();
            }
            return new Report(id$value, timestamp$value, this.reporter, this.reported, this.reporterName, this.reportedName, this.reason, status$value, this.markedAs, this.reporterPosition, this.reportedPosition, this.discordMessageId, comments$value);
        }

        @Generated
        public String toString() {
            return "Report.ReportBuilder(id$value=" + this.id$value + ", timestamp$value=" + this.timestamp$value + ", reporter=" + String.valueOf(this.reporter) + ", reported=" + String.valueOf(this.reported) + ", reporterName=" + this.reporterName + ", reportedName=" + this.reportedName + ", reason=" + this.reason + ", status$value=" + String.valueOf((Object)this.status$value) + ", markedAs=" + String.valueOf((Object)this.markedAs) + ", reporterPosition=" + String.valueOf(this.reporterPosition) + ", reportedPosition=" + String.valueOf(this.reportedPosition) + ", discordMessageId=" + this.discordMessageId + ", comments$value=" + String.valueOf(this.comments$value) + ")";
        }
    }

    public static enum Status {
        WAITING,
        IN_PROGRESS,
        DONE,
        ARCHIVED,
        OPEN;


        public static Optional<Status> parse(@NotNull String string) {
            return Arrays.stream(Status.values()).filter(operation -> operation.name().equalsIgnoreCase(string)).findFirst();
        }
    }

    public static enum MarkedAs {
        TRUE,
        FALSE;


        public static Optional<MarkedAs> parse(@NotNull String string) {
            return Arrays.stream(MarkedAs.values()).filter(operation -> operation.name().equalsIgnoreCase(string)).findFirst();
        }
    }
}

