/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.network;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.network.Message;
import dev.xf3d3.ultimatereports.network.MessageHandler;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.entity.Player;

public abstract class Broker
implements MessageHandler {
    protected final UltimateReports plugin;

    protected Broker(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    protected void handle(@Nullable Player receiver, @NotNull Message message) {
        if (message.getSourceServer().equals(this.getServer())) {
            return;
        }
        switch (message.getType()) {
            case REQUEST_USER_LIST: {
                this.handleRequestUserList(message, receiver);
                break;
            }
            case UPDATE_USER_LIST: {
                this.handleUpdateUserList(message);
                break;
            }
            case REPORT_DELETE: {
                this.handleReportDelete(message);
                break;
            }
            case REPORT_UPDATE: {
                this.handleReportUpdate(message);
                break;
            }
            default: {
                this.plugin.log(Level.SEVERE, "Received unknown message type: " + String.valueOf((Object)message.getType()), new Throwable[0]);
            }
        }
    }

    public abstract void initialize() throws RuntimeException;

    public abstract void changeServer(@NotNull Player var1, @NotNull String var2);

    protected abstract void send(@NotNull Message var1, @Nullable Player var2);

    public abstract void close();

    @NotNull
    protected String getSubChannelId() {
        return String.valueOf(this.plugin.getSettings().getCrossServer().getClusterId());
    }

    protected String getServer() {
        return this.plugin.getSettings().getCrossServer().getServerName();
    }

    @NotNull
    private String getFormattedVersion() {
        return String.format("%s.%s", this.plugin.getPluginVersion().getMajor(), this.plugin.getPluginVersion().getMinor());
    }

    @Override
    @NotNull
    public Broker getBroker() {
        return this;
    }

    @Override
    @Generated
    public UltimateReports getPlugin() {
        return this.plugin;
    }

    public static enum Type {
        PLUGIN_MESSAGE("Plugin Messages"),
        REDIS("Redis");

        @NotNull
        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

