/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.network;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.models.Report;
import dev.xf3d3.ultimatereports.models.User;
import dev.xf3d3.ultimatereports.network.Broker;
import dev.xf3d3.ultimatereports.network.Message;
import dev.xf3d3.ultimatereports.network.Payload;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public interface MessageHandler {
    default public void handleRequestUserList(@NotNull Message message, @Nullable Player receiver) {
        if (receiver == null) {
            return;
        }
        Message.builder().type(Message.Type.UPDATE_USER_LIST).payload(Payload.userList(Bukkit.getOnlinePlayers().stream().map(online -> User.of(online.getUniqueId(), online.getName())).toList())).target(message.getSourceServer(), Message.TargetType.SERVER).build().send(this.getBroker(), receiver);
    }

    default public void handleUpdateUserList(@NotNull Message message) {
        message.getPayload().getUserList().ifPresent(players -> this.getPlugin().getUsersManager().setUserList(message.getSourceServer(), (List<User>)players));
    }

    default public void handleReportDelete(@NotNull Message message) {
        message.getPayload().getInteger().flatMap(teamID -> this.getPlugin().getReportsManager().getReports().stream().filter(team -> team.getId() == teamID.intValue()).findFirst()).ifPresent(team -> this.getPlugin().getReportsManager().getReports().remove(team));
    }

    default public void handleReportUpdate(@NotNull Message message) {
        message.getPayload().getInteger().ifPresent(id -> this.getPlugin().runAsync(task -> this.getPlugin().getDatabase().getReport((int)id).ifPresentOrElse(team -> this.getPlugin().getReportsManager().updateReportLocal((Report)team, team.getId()), () -> this.getPlugin().log(Level.WARNING, "Failed to update team: Team not found", new Throwable[0]))));
    }

    @NotNull
    public Broker getBroker();

    @NotNull
    public UltimateReports getPlugin();
}

