/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.network.Broker;
import dev.xf3d3.ultimatereports.network.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PluginMessageBroker
extends Broker {
    public static final String BUNGEE_CHANNEL_ID = "BungeeCord";

    public PluginMessageBroker(@NotNull UltimateReports plugin) {
        super(plugin);
    }

    @Override
    public void initialize() throws RuntimeException {
        this.plugin.initializePluginChannels();
    }

    public final void onReceive(@NotNull String channel, @NotNull Player user, byte[] message) {
        if (!channel.equals(BUNGEE_CHANNEL_ID)) {
            return;
        }
        ByteArrayDataInput inputStream = ByteStreams.newDataInput((byte[])message);
        String subChannelId = inputStream.readUTF();
        if (!subChannelId.equals(this.getSubChannelId())) {
            return;
        }
        short messageLength = inputStream.readShort();
        byte[] messageBody = new byte[messageLength];
        inputStream.readFully(messageBody);
        try (DataInputStream messageReader = new DataInputStream(new ByteArrayInputStream(messageBody));){
            super.handle(user, this.plugin.getMessageFromJson(messageReader.readUTF()));
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Failed to fully read plugin message", e);
        }
    }

    @Override
    protected void send(@NotNull Message message, @Nullable Player sender) {
        if (sender == null) {
            return;
        }
        ByteArrayDataOutput messageWriter = ByteStreams.newDataOutput();
        messageWriter.writeUTF(message.getTargetType().getPluginMessageChannel());
        messageWriter.writeUTF(message.getTarget());
        messageWriter.writeUTF(this.getSubChannelId());
        try (ByteArrayOutputStream messageByteStream = new ByteArrayOutputStream();
             DataOutputStream messageDataStream = new DataOutputStream(messageByteStream);){
            messageDataStream.writeUTF(this.plugin.getGson().toJson(message));
            messageWriter.writeShort(messageByteStream.toByteArray().length);
            messageWriter.write(messageByteStream.toByteArray());
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Exception dispatching plugin message", e);
            return;
        }
        sender.sendPluginMessage((Plugin)this.plugin, BUNGEE_CHANNEL_ID, messageWriter.toByteArray());
    }

    @Override
    public void changeServer(@NotNull Player user, @NotNull String server) {
        ByteArrayDataOutput outputStream = ByteStreams.newDataOutput();
        outputStream.writeUTF("Connect");
        outputStream.writeUTF(server);
        user.sendPluginMessage((Plugin)this.plugin, BUNGEE_CHANNEL_ID, outputStream.toByteArray());
    }

    @Override
    public void close() {
    }
}

