/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.network;

import com.google.common.collect.Sets;
import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.config.Settings;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.network.Message;
import dev.xf3d3.ultimatereports.network.PluginMessageBroker;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public class RedisBroker
extends PluginMessageBroker {
    private Pool<Jedis> jedisPool;

    public RedisBroker(@NotNull UltimateReports plugin) {
        super(plugin);
    }

    @Override
    public void initialize() throws RuntimeException {
        super.initialize();
        this.jedisPool = this.establishJedisPool();
        new Thread(this.getSubscriber(), "UltimateReports_redis_subscriber").start();
        this.plugin.log(Level.INFO, "Initialized Redis connection pool", new Throwable[0]);
    }

    @NotNull
    private Pool<Jedis> establishJedisPool() {
        JedisPool pool;
        Settings.CrossServerSettings.RedisSettings settings = this.plugin.getSettings().getCrossServer().getRedis();
        HashSet sentinelNodes = Sets.newHashSet(settings.getSentinel().getNodes());
        if (sentinelNodes.isEmpty()) {
            pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), settings.getHost(), settings.getPort(), 0, settings.getPassword().isEmpty() ? null : settings.getPassword(), settings.isUseSsl());
            this.plugin.log(Level.INFO, "Using Redis pool", new Throwable[0]);
        } else {
            pool = new JedisSentinelPool(settings.getSentinel().getMasterName(), (Set)sentinelNodes, settings.getPassword().isEmpty() ? null : settings.getPassword(), settings.getSentinel().getPassword().isEmpty() ? null : settings.getSentinel().getPassword());
            this.plugin.log(Level.INFO, "Using Redis Sentinel pool", new Throwable[0]);
        }
        return pool;
    }

    @NotNull
    private Runnable getSubscriber() {
        return () -> {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.subscribe(new JedisPubSub(){

                    public void onMessage(@NotNull String channel, @NotNull String encodedMessage) {
                        if (!channel.equals(RedisBroker.this.getSubChannelId())) {
                            return;
                        }
                        Message message = RedisBroker.this.plugin.getMessageFromJson(encodedMessage);
                        if (message.getTargetType() == Message.TargetType.PLAYER) {
                            Bukkit.getOnlinePlayers().stream().filter(online -> online.getName().equalsIgnoreCase(message.getTarget())).findFirst().ifPresent(receiver -> RedisBroker.this.handle((Player)receiver, message));
                            return;
                        }
                        RedisBroker.this.handle(Bukkit.getOnlinePlayers().stream().findAny().orElse(null), message);
                    }
                }, new String[]{this.getSubChannelId()});
            }
        };
    }

    @Override
    protected void send(@NotNull Message message, @Nullable Player sender) {
        this.plugin.runAsync(task -> {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.publish(this.getSubChannelId(), this.plugin.getGson().toJson(message));
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
    }
}

