/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.utils;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Position;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Utils {
    private final UltimateReports plugin;
    private DateTimeFormatter formatter;

    public Utils(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
        this.setDateFormat();
    }

    public void teleport(@NotNull Player player, @NotNull Position position) {
        if (this.plugin.getSettings().getCrossServer().isEnabled() && position.getServer() != null && !position.getServer().equals(this.plugin.getSettings().getCrossServer().getServerName())) {
            this.plugin.getUsersManager().getPlayer(player.getUniqueId()).thenAccept(user -> {
                user.getPreferences().setTeleportTarget(position);
                this.plugin.getUsersManager().updatePlayer((OnlinePlayer)user);
                this.plugin.getMessageBroker().ifPresent(broker -> broker.changeServer(player, position.getServer()));
            });
            return;
        }
        player.teleportAsync(position.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "g " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    public String formatDate(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).format(this.formatter);
    }

    public void setDateFormat() {
        this.formatter = DateTimeFormatter.ofPattern(this.plugin.getSettings().getGeneral().getDateFormat());
    }
}

