/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.utils.gson;

import dev.xf3d3.ultimatereports.libraries.gson.JsonDeserializationContext;
import dev.xf3d3.ultimatereports.libraries.gson.JsonDeserializer;
import dev.xf3d3.ultimatereports.libraries.gson.JsonElement;
import dev.xf3d3.ultimatereports.libraries.gson.JsonParseException;
import dev.xf3d3.ultimatereports.libraries.gson.JsonPrimitive;
import dev.xf3d3.ultimatereports.libraries.gson.JsonSerializationContext;
import dev.xf3d3.ultimatereports.libraries.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class OffsetDateTimeConverter
implements JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @Override
    public JsonElement serialize(OffsetDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(FORMATTER.format(src));
    }

    @Override
    public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return FORMATTER.parse((CharSequence)json.getAsString(), OffsetDateTime::from);
    }
}

