/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.magnetic.extensions;

import dev.nyon.magnetic.MainKt;
import dev.nyon.magnetic.config.ConfigCacheKt;
import dev.nyon.magnetic.config.ConfigKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\b\u001a\u00020\u0001*\u0004\u0018\u00010\t\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\n"}, d2={"hasMagnetic", "", "Lorg/bukkit/inventory/ItemStack;", "isAllowedToUseMagnetic", "Lorg/bukkit/entity/Player;", "isIgnored", "Lorg/bukkit/entity/EntityType;", "(Lorg/bukkit/entity/EntityType;)Z", "failsLongRangeCheck", "Lorg/bukkit/event/entity/EntityDamageEvent;", "magnetic"})
@SourceDebugExtension(value={"SMAP\nMagneticCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagneticCheck.kt\ndev/nyon/magnetic/extensions/MagneticCheckKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n188#2,3:35\n2746#3,3:38\n*S KotlinDebug\n*F\n+ 1 MagneticCheck.kt\ndev/nyon/magnetic/extensions/MagneticCheckKt\n*L\n12#1:35,3\n18#1:38,3\n*E\n"})
public final class MagneticCheckKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasMagnetic(@NotNull ItemStack $this$hasMagnetic) {
        Map.Entry it;
        Intrinsics.checkNotNullParameter((Object)$this$hasMagnetic, (String)"<this>");
        if (!$this$hasMagnetic.hasItemMeta()) return false;
        Map map = $this$hasMagnetic.getItemMeta().getEnchants();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
        Map $this$any$iv = map;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)((Enchantment)it.getKey()).getKey(), (Object)MainKt.getMagneticKey()));
        return true;
    }

    public static final boolean isAllowedToUseMagnetic(@NotNull Player $this$isAllowedToUseMagnetic) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowedToUseMagnetic, (String)"<this>");
        if (ConfigKt.getConfig().getEnchantmentRequired()) {
            boolean bl;
            block6: {
                Object[] objectArray = new ItemStack[]{$this$isAllowedToUseMagnetic.getInventory().getItemInMainHand(), $this$isAllowedToUseMagnetic.getInventory().getItemInOffHand()};
                Iterable $this$none$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!MagneticCheckKt.hasMagnetic(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return false;
            }
        }
        if (ConfigKt.getConfig().getSneakRequired() && !$this$isAllowedToUseMagnetic.isSneaking()) {
            return false;
        }
        return !ConfigKt.getConfig().getPermissionRequired() || $this$isAllowedToUseMagnetic.hasPermission("magnetic.ability.use");
    }

    public static final boolean isIgnored(@NotNull EntityType $this$isIgnored) {
        Intrinsics.checkNotNullParameter((Object)$this$isIgnored, (String)"<this>");
        return ConfigCacheKt.getIgnoredEntities().contains($this$isIgnored.getKey());
    }

    public static final boolean failsLongRangeCheck(@Nullable EntityDamageEvent $this$failsLongRangeCheck) {
        if ($this$failsLongRangeCheck == null) {
            return true;
        }
        return ConfigKt.getConfig().getIgnoreRangedWeapons() && $this$failsLongRangeCheck.getCause() == EntityDamageEvent.DamageCause.PROJECTILE;
    }
}

