/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.magnetic;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.tags.EnchantmentTagKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import io.papermc.paper.tag.PreFlattenTagRegistrar;
import io.papermc.paper.tag.TagEntry;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.NotNull;

public class MagneticBootstrapper
implements PluginBootstrap {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void bootstrap(@NotNull BootstrapContext context) {
        @NotNull LifecycleEventManager manager = context.getLifecycleManager();
        if (!this.needsEnchantment()) {
            return;
        }
        TagKey TOOLS = TagKey.create((RegistryKey)RegistryKey.ITEM, (Key)Key.key((String)"magnetic:tools"));
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.TAGS.preFlatten(RegistryKey.ITEM), event -> {
            @NotNull PreFlattenTagRegistrar registrar = (PreFlattenTagRegistrar)event.registrar();
            registrar.addToTag(TOOLS, (Collection)Set.of(ItemTypeTagKeys.ENCHANTABLE_WEAPON, ItemTypeTagKeys.ENCHANTABLE_MINING, ItemTypeTagKeys.ENCHANTABLE_BOW, ItemTypeTagKeys.ENCHANTABLE_CROSSBOW, ItemTypeTagKeys.ENCHANTABLE_FISHING, ItemTypeTagKeys.CREEPER_IGNITERS, ItemTypeTagKeys.ENCHANTABLE_TRIDENT).stream().map(TagEntry::tagEntry).collect(Collectors.toSet()));
        });
        TypedKey MAGNETIC = TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)Key.key((String)"magnetic:magnetic"));
        manager.registerEventHandler(RegistryEvents.ENCHANTMENT.compose().newHandler(event -> event.registry().register(MAGNETIC, builder -> builder.description((Component)Component.text((String)"Magnetic")).supportedItems((RegistryKeySet)event.getOrCreateTag(TOOLS)).weight(2).maxLevel(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)25, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)75, (int)0)).anvilCost(7).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND}))));
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.TAGS.postFlatten(RegistryKey.ENCHANTMENT), event -> {
            @NotNull PostFlattenTagRegistrar registrar = (PostFlattenTagRegistrar)event.registrar();
            registrar.addToTag(EnchantmentTagKeys.TRADEABLE, Set.of(MAGNETIC));
            registrar.addToTag(EnchantmentTagKeys.TREASURE, Set.of(MAGNETIC));
            registrar.addToTag(EnchantmentTagKeys.IN_ENCHANTING_TABLE, Set.of(MAGNETIC));
        });
    }

    private boolean needsEnchantment() {
        try {
            List<String> configText = Files.readAllLines(Path.of("./plugins/magnetic/magnetic.json", new String[0]));
            return configText.stream().anyMatch(line -> line.contains("ENCHANTMENT"));
        }
        catch (Exception e) {
            return true;
        }
    }
}

