/*
 * Decompiled with CFR 0.152.
 */
package com.invhudplus.soulspeed.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.invhudplus.soulspeed.InventoryHUD;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("inventory-hud.json").toFile();
    private boolean showArmorHud = true;
    private boolean showToolDurability = true;
    private boolean showPotionEffects = false;
    private boolean showInventoryPreview = true;
    private float armorHudX = 0.01f;
    private float armorHudY = 0.01f;
    private float toolDurabilityX = 0.01f;
    private float toolDurabilityY = 0.15f;
    private float potionEffectsX = 0.99f;
    private float potionEffectsY = 0.01f;
    private float inventoryPreviewX = 0.99f;
    private float inventoryPreviewY = 0.99f;
    private float armorHudScale = 1.0f;
    private float toolDurabilityScale = 1.0f;
    private float potionEffectsScale = 1.0f;
    private float inventoryPreviewScale = 1.0f;
    private float hudOpacity = 0.8f;
    private boolean enableTextureCaching = true;
    private boolean enableSmartRendering = true;

    public static ModConfig load() {
        ModConfig config;
        block8: {
            config = new ModConfig();
            try {
                if (CONFIG_FILE.exists()) {
                    try (FileReader reader = new FileReader(CONFIG_FILE);){
                        config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                        InventoryHUD.LOGGER.info("Loaded configuration from " + CONFIG_FILE.getAbsolutePath());
                        break block8;
                    }
                }
                ModConfig.save(config);
                InventoryHUD.LOGGER.info("Created default configuration at " + CONFIG_FILE.getAbsolutePath());
            }
            catch (IOException e) {
                InventoryHUD.LOGGER.error("Failed to load configuration", (Throwable)e);
            }
        }
        return config;
    }

    public static void save(ModConfig config) {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            InventoryHUD.LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public boolean isShowArmorHud() {
        return this.showArmorHud;
    }

    public void setShowArmorHud(boolean showArmorHud) {
        this.showArmorHud = showArmorHud;
    }

    public boolean isShowToolDurability() {
        return this.showToolDurability;
    }

    public void setShowToolDurability(boolean showToolDurability) {
        this.showToolDurability = showToolDurability;
    }

    public boolean isShowPotionEffects() {
        return this.showPotionEffects;
    }

    public void setShowPotionEffects(boolean showPotionEffects) {
        this.showPotionEffects = showPotionEffects;
    }

    public boolean isShowInventoryPreview() {
        return this.showInventoryPreview;
    }

    public void setShowInventoryPreview(boolean showInventoryPreview) {
        this.showInventoryPreview = showInventoryPreview;
    }

    public float getArmorHudX() {
        return this.armorHudX;
    }

    public void setArmorHudX(float armorHudX) {
        this.armorHudX = armorHudX;
    }

    public float getArmorHudY() {
        return this.armorHudY;
    }

    public void setArmorHudY(float armorHudY) {
        this.armorHudY = armorHudY;
    }

    public float getToolDurabilityX() {
        return this.toolDurabilityX;
    }

    public void setToolDurabilityX(float toolDurabilityX) {
        this.toolDurabilityX = toolDurabilityX;
    }

    public float getToolDurabilityY() {
        return this.toolDurabilityY;
    }

    public void setToolDurabilityY(float toolDurabilityY) {
        this.toolDurabilityY = toolDurabilityY;
    }

    public float getPotionEffectsX() {
        return this.potionEffectsX;
    }

    public void setPotionEffectsX(float potionEffectsX) {
        this.potionEffectsX = potionEffectsX;
    }

    public float getPotionEffectsY() {
        return this.potionEffectsY;
    }

    public void setPotionEffectsY(float potionEffectsY) {
        this.potionEffectsY = potionEffectsY;
    }

    public float getInventoryPreviewX() {
        return this.inventoryPreviewX;
    }

    public void setInventoryPreviewX(float inventoryPreviewX) {
        this.inventoryPreviewX = inventoryPreviewX;
    }

    public float getInventoryPreviewY() {
        return this.inventoryPreviewY;
    }

    public void setInventoryPreviewY(float inventoryPreviewY) {
        this.inventoryPreviewY = inventoryPreviewY;
    }

    public float getArmorHudScale() {
        return this.armorHudScale;
    }

    public void setArmorHudScale(float armorHudScale) {
        this.armorHudScale = armorHudScale;
    }

    public float getToolDurabilityScale() {
        return this.toolDurabilityScale;
    }

    public void setToolDurabilityScale(float toolDurabilityScale) {
        this.toolDurabilityScale = toolDurabilityScale;
    }

    public float getPotionEffectsScale() {
        return this.potionEffectsScale;
    }

    public void setPotionEffectsScale(float potionEffectsScale) {
        this.potionEffectsScale = potionEffectsScale;
    }

    public float getInventoryPreviewScale() {
        return this.inventoryPreviewScale;
    }

    public void setInventoryPreviewScale(float inventoryPreviewScale) {
        this.inventoryPreviewScale = inventoryPreviewScale;
    }

    public float getHudOpacity() {
        return this.hudOpacity;
    }

    public void setHudOpacity(float hudOpacity) {
        this.hudOpacity = hudOpacity;
    }

    public boolean isEnableTextureCaching() {
        return this.enableTextureCaching;
    }

    public void setEnableTextureCaching(boolean enableTextureCaching) {
        this.enableTextureCaching = enableTextureCaching;
    }

    public boolean isEnableSmartRendering() {
        return this.enableSmartRendering;
    }

    public void setEnableSmartRendering(boolean enableSmartRendering) {
        this.enableSmartRendering = enableSmartRendering;
    }
}

