/*
 * Decompiled with CFR 0.152.
 */
package com.invhudplus.soulspeed.hud;

import com.invhudplus.soulspeed.InventoryHUD;
import com.invhudplus.soulspeed.hud.HudRenderer;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ArmorHudRenderer
implements HudRenderer {
    private static final int ITEM_SIZE = 16;
    private static final int SPACING = 2;
    private static final int DURABILITY_HEIGHT = 2;

    @Override
    public boolean isEnabled() {
        return InventoryHUD.CONFIG.isShowArmorHud();
    }

    @Override
    public void render(class_332 context, class_310 client, Object tickDelta) {
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = this.normalizedToScreen(InventoryHUD.CONFIG.getArmorHudX(), screenWidth);
        int y = this.normalizedToScreen(InventoryHUD.CONFIG.getArmorHudY(), screenHeight);
        float scale = InventoryHUD.CONFIG.getArmorHudScale();
        int scaledItemSize = Math.round(16.0f * scale);
        class_1799 helmet = client.field_1724.method_6118(class_1304.field_6169);
        class_1799 chestplate = client.field_1724.method_6118(class_1304.field_6174);
        class_1799 leggings = client.field_1724.method_6118(class_1304.field_6172);
        class_1799 boots = client.field_1724.method_6118(class_1304.field_6166);
        this.renderArmorItem(context, helmet, x, y, scale);
        this.renderArmorItem(context, chestplate, x, y + (scaledItemSize + 2), scale);
        this.renderArmorItem(context, leggings, x, y + 2 * (scaledItemSize + 2), scale);
        this.renderArmorItem(context, boots, x, y + 3 * (scaledItemSize + 2), scale);
    }

    private void renderArmorItem(class_332 context, class_1799 stack, int x, int y, float scale) {
        if (stack.method_7960()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22905(scale, scale, 1.0f);
        int scaledX = Math.round((float)x / scale);
        int scaledY = Math.round((float)y / scale);
        context.method_51427(stack, scaledX, scaledY);
        if (stack.method_7963()) {
            int maxDurability = stack.method_7936();
            int durability = maxDurability - stack.method_7919();
            float durabilityPercent = (float)durability / (float)maxDurability;
            context.method_25294(scaledX, scaledY + 16 + 1, scaledX + 16, scaledY + 16 + 1 + 2, this.applyOpacity(Integer.MIN_VALUE));
            int barWidth = Math.round(16.0f * durabilityPercent);
            int barColor = this.getDurabilityColor(durabilityPercent);
            context.method_25294(scaledX, scaledY + 16 + 1, scaledX + barWidth, scaledY + 16 + 1 + 2, this.applyOpacity(barColor));
        }
        context.method_51448().method_22909();
    }

    private int getDurabilityColor(float percent) {
        if (percent > 0.75f) {
            return -16711936;
        }
        if (percent > 0.5f) {
            return -256;
        }
        if (percent > 0.25f) {
            return Short.MIN_VALUE;
        }
        return -65536;
    }
}

