/*
 * Decompiled with CFR 0.152.
 */
package com.invhudplus.soulspeed.hud;

import com.invhudplus.soulspeed.InventoryHUD;
import com.invhudplus.soulspeed.hud.HudRenderer;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ToolDurabilityRenderer
implements HudRenderer {
    private static final int ITEM_SIZE = 16;
    private static final int SPACING = 2;
    private static final int DURABILITY_HEIGHT = 2;

    @Override
    public boolean isEnabled() {
        return InventoryHUD.CONFIG.isShowToolDurability();
    }

    @Override
    public void render(class_332 context, class_310 client, Object tickDelta) {
        class_1799 offHandItem;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = this.normalizedToScreen(InventoryHUD.CONFIG.getToolDurabilityX(), screenWidth);
        int y = this.normalizedToScreen(InventoryHUD.CONFIG.getToolDurabilityY(), screenHeight);
        float scale = InventoryHUD.CONFIG.getToolDurabilityScale();
        class_1799 mainHandItem = client.field_1724.method_6047();
        if (!mainHandItem.method_7960() && mainHandItem.method_7963()) {
            this.renderToolItem(context, mainHandItem, x, y, scale);
        }
        if (!(offHandItem = client.field_1724.method_6079()).method_7960() && offHandItem.method_7963()) {
            int scaledItemSize = Math.round(16.0f * scale);
            this.renderToolItem(context, offHandItem, x, y + scaledItemSize + 2, scale);
        }
    }

    private void renderToolItem(class_332 context, class_1799 stack, int x, int y, float scale) {
        context.method_51448().method_22903();
        context.method_51448().method_22905(scale, scale, 1.0f);
        int scaledX = Math.round((float)x / scale);
        int scaledY = Math.round((float)y / scale);
        context.method_51427(stack, scaledX, scaledY);
        int maxDurability = stack.method_7936();
        int durability = maxDurability - stack.method_7919();
        float durabilityPercent = (float)durability / (float)maxDurability;
        context.method_25294(scaledX, scaledY + 16 + 1, scaledX + 16, scaledY + 16 + 1 + 2, this.applyOpacity(Integer.MIN_VALUE));
        int barWidth = Math.round(16.0f * durabilityPercent);
        int barColor = this.getDurabilityColor(durabilityPercent);
        context.method_25294(scaledX, scaledY + 16 + 1, scaledX + barWidth, scaledY + 16 + 1 + 2, this.applyOpacity(barColor));
        String durabilityText = durability + "/" + maxDurability;
        int textX = scaledX + 16 + 2;
        int textY = scaledY + 4;
        context.method_51433(class_310.method_1551().field_1772, durabilityText, textX, textY, this.applyOpacity(this.getDurabilityColor(durabilityPercent)), false);
        context.method_51448().method_22909();
    }

    private int getDurabilityColor(float percent) {
        if (percent > 0.75f) {
            return -16711936;
        }
        if (percent > 0.5f) {
            return -256;
        }
        if (percent > 0.25f) {
            return Short.MIN_VALUE;
        }
        return -65536;
    }
}

