/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Timer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.tejty.gamediscs.client.ClientUtils;
import net.tejty.gamediscs.client.screen.VisualButton;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.item.custom.GameDiscItem;

public class GamingConsoleScreen
extends class_437 {
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"gamediscs", (String)"textures/gui/gaming_console.png");
    private static final int CONSOLE_WIDTH = 160;
    private static final int CONSOLE_HEIGHT = 198;
    private static final int SCREEN_X = 10;
    private static final int SCREEN_Y = 10;
    private static final int W = 87;
    private static final int S = 83;
    private static final int A = 65;
    private static final int D = 68;
    private static final int SPACE = 32;
    private static final int ENTER = 257;
    private static final VisualButton W_BUTTON = new VisualButton(BACKGROUND, 256, 256, 33, 121, 14, 24, 183, 0, 24);
    private static final VisualButton A_BUTTON = new VisualButton(BACKGROUND, 256, 256, 17, 137, 23, 15, 160, 0, 24);
    private static final VisualButton D_BUTTON = new VisualButton(BACKGROUND, 256, 256, 40, 137, 23, 15, 197, 0, 24);
    private static final VisualButton S_BUTTON = new VisualButton(BACKGROUND, 256, 256, 33, 145, 14, 23, 220, 0, 24);
    private static final VisualButton B1_BUTTON = new VisualButton(BACKGROUND, 256, 256, 96, 136, 16, 16, 234, 0, 24);
    private static final VisualButton B2_BUTTON = new VisualButton(BACKGROUND, 256, 256, 128, 128, 16, 16, 234, 0, 24);
    private List<Game> availableGames = new ArrayList<Game>();
    private int selected = 0;
    private Game game = new Game();

    private int getConsoleX() {
        return (this.field_22789 - 160) / 2;
    }

    private int getConsoleY() {
        return (this.field_22790 - 198) / 2;
    }

    public GamingConsoleScreen(class_2561 title) {
        super(title);
        this.availableGames = this.scanForGames();
        Timer timer = new Timer(50, e -> {
            if (this.game != null) {
                this.game.tick();
            }
        });
        timer.start();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25420(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderMyBackground(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderGameScreen(graphics, this.getConsoleX() + 10, this.getConsoleY() + 10);
        this.renderButtons(graphics);
    }

    public void renderMyBackground(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25291(BACKGROUND, this.getConsoleX(), this.getConsoleY(), 0, 0.0f, 0.0f, 160, 198, 256, 256);
    }

    private void renderGameScreen(class_332 graphics, int x, int y) {
        graphics.method_44379(x, y, x + 140, y + 100);
        if (!this.game.isEmpty()) {
            this.game.render(graphics, x, y);
        } else {
            this.renderGameSelection(graphics, x, y);
        }
        graphics.method_44380();
    }

    private void renderGameSelection(class_332 graphics, int x, int y) {
        if (!this.availableGames.isEmpty()) {
            class_2960 class_29602 = class_2960.method_60655((String)"gamediscs", (String)"textures/gui/selected.png");
            Objects.requireNonNull(this.field_22793);
            graphics.method_25291(class_29602, x, y + 3 + 9 + 18 * this.selected - Math.max(0, this.selected - 3) * 18, 0, 0.0f, 0.0f, 140, 18, 140, 18);
        } else {
            graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.gamingconsole.no_selectable_game").method_27692(class_124.field_1056), x + (140 - this.field_22793.method_30880(class_2561.method_43471((String)"gui.gamingconsole.no_selectable_game").method_27692(class_124.field_1067).method_30937())) / 2, y + 26, 11330875, false);
        }
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.gamingconsole.select_game").method_27692(class_124.field_1067), x + (140 - this.field_22793.method_30880(class_2561.method_43471((String)"gui.gamingconsole.select_game").method_27692(class_124.field_1067).method_30937())) / 2, y + 3 - Math.max(0, this.selected - 3) * 18, 11330875, false);
        for (int i = 0; i < this.availableGames.size(); ++i) {
            class_5250 class_52502 = class_2561.method_43470((String)this.availableGames.get(i).getName().getString()).method_27695(new class_124[]{this.availableGames.get(i).getColor(), i == this.selected ? class_124.field_1067 : class_124.field_1056});
            Objects.requireNonNull(this.field_22793);
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, (class_2561)class_52502, x + 22, y + 4 + 9 + 18 * i + (18 - 9) / 2 - Math.max(0, this.selected - 3) * 18, this.availableGames.get(i).getColor().method_532().intValue(), false);
            class_2960 class_29603 = this.availableGames.get(i).getIcon();
            Objects.requireNonNull(this.field_22793);
            graphics.method_25291(class_29603, x + 3, y + 4 + 9 + 18 * i - Math.max(0, this.selected - 3) * 18, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void renderButtons(class_332 graphics) {
        W_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.UP));
        A_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.LEFT));
        D_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.RIGHT));
        S_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.DOWN));
        B1_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.BUTTON1));
        B2_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.BUTTON2));
    }

    public List<Game> scanForGames() {
        ArrayList<Game> games = new ArrayList<Game>();
        class_1657 player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1792 class_17922 = player.method_31548().method_5438(i).method_7909();
            if (!(class_17922 instanceof GameDiscItem)) continue;
            GameDiscItem disc = (GameDiscItem)class_17922;
            games.add(ClientUtils.newGameFor(disc));
        }
        return games;
    }

    public boolean method_25404(int key, int pScanCode, int pModifiers) {
        boolean flag = false;
        if (!this.game.isEmpty()) {
            if (key == 81) {
                this.game = new Game();
                flag = true;
                this.game.soundPlayer.playConfirm();
            } else if (key == 82) {
                this.game.prepare();
                flag = true;
                this.game.soundPlayer.playConfirm();
            }
        } else if (key == 81) {
            this.field_22787.method_1507(null);
            return true;
        }
        if (this.game != null) {
            switch (key) {
                case 87: {
                    this.game.controls.setButton(Button.UP, true);
                    flag = true;
                    break;
                }
                case 83: {
                    this.game.controls.setButton(Button.DOWN, true);
                    flag = true;
                    break;
                }
                case 65: {
                    this.game.controls.setButton(Button.LEFT, true);
                    flag = true;
                    break;
                }
                case 68: {
                    this.game.controls.setButton(Button.RIGHT, true);
                    flag = true;
                    break;
                }
                case 32: {
                    this.game.controls.setButton(Button.BUTTON1, true);
                    flag = true;
                    break;
                }
                case 257: {
                    this.game.controls.setButton(Button.BUTTON2, true);
                    flag = true;
                }
            }
        }
        if (this.game.isEmpty()) {
            int newSelected;
            if (key == 87) {
                newSelected = this.selected - 1;
                if (newSelected < 0) {
                    newSelected = this.availableGames.size() - 1;
                }
                this.selected = newSelected;
                flag = true;
                this.game.soundPlayer.playSelect();
            }
            if (key == 83) {
                newSelected = this.selected + 1;
                if (newSelected > this.availableGames.size() - 1) {
                    newSelected = 0;
                }
                this.selected = newSelected;
                flag = true;
                this.game.soundPlayer.playSelect();
            }
            if (!(key != 32 && key != 257 || this.availableGames.isEmpty())) {
                Game newGame = this.availableGames.get(this.selected);
                newGame.prepare();
                this.game = newGame;
                flag = true;
                this.game.soundPlayer.playConfirm();
            }
        }
        return super.method_25404(key, pScanCode, pModifiers) || flag;
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        boolean flag = false;
        if (this.game != null) {
            switch (pKeyCode) {
                case 87: {
                    this.game.controls.setButton(Button.UP, false);
                    flag = true;
                    break;
                }
                case 83: {
                    this.game.controls.setButton(Button.DOWN, false);
                    flag = true;
                    break;
                }
                case 65: {
                    this.game.controls.setButton(Button.LEFT, false);
                    flag = true;
                    break;
                }
                case 68: {
                    this.game.controls.setButton(Button.RIGHT, false);
                    flag = true;
                    break;
                }
                case 32: {
                    this.game.controls.setButton(Button.BUTTON1, false);
                    flag = true;
                    break;
                }
                case 257: {
                    this.game.controls.setButton(Button.BUTTON2, false);
                    flag = true;
                }
            }
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers) || flag;
    }

    public void method_25419() {
        super.method_25419();
        this.game = null;
    }
}

