/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.AnimatedImage;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;

public class FlappyBirdGame
extends Game {
    private Sprite bird = new Sprite(new class_241(20.0f, 30.0f), new class_241(10.0f, 8.0f), new AnimatedImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/bird.png"), 10, 32, 4, 2));
    private List<Sprite> pipes = new ArrayList<Sprite>();
    private final Sprite ground = new Sprite(new class_241(0.0f, 84.0f), new class_241(156.0f, 16.0f), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/ground.png"));
    private int pipeSpawnTimer = 0;

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.bird = new Sprite(new class_241(20.0f, 30.0f), new class_241(10.0f, 8.0f), new AnimatedImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/bird.png"), 10, 32, 4, 2));
        this.pipes = new ArrayList<Sprite>();
        this.ground.setVelocity(new class_241(-2.5f, 0.0f));
        this.bird.show();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.pipeSpawnTimer = 0;
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if (this.stage != GameStage.DIED) {
            this.bird.animTick();
        }
        if (this.stage != GameStage.DIED && this.stage != GameStage.WON) {
            this.ground.tick();
            if (this.ground.getX() <= -16.0f) {
                this.ground.moveBy(new class_241(16.0f, 0.0f));
            }
        }
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        this.bird.tick();
        this.bird.addVelocity(new class_241(0.0f, 0.75f));
        this.bird.setVelocity(this.bird.getVelocity().method_35582(0.9f));
        if (this.pipeSpawnTimer <= 0) {
            this.spawnPipe();
            this.pipeSpawnTimer = 30;
        }
        for (int i = 0; i < this.pipes.size(); ++i) {
            Sprite pipe = this.pipes.get(i);
            boolean flag = pipe.getX() + pipe.getWidth() >= this.bird.getX() && pipe.getY() < 0.0f;
            pipe.tick();
            if (flag && pipe.getX() + pipe.getWidth() < this.bird.getX()) {
                ++this.score;
                this.soundPlayer.playPoint();
            }
            if (pipe.getX() + pipe.getWidth() < 0.0f) {
                this.pipes.remove(pipe);
                --i;
            }
            if (!this.bird.isTouching(pipe)) continue;
            this.die();
        }
        if (this.bird.isTouching(this.ground) || this.bird.getY() < 0.0f) {
            this.die();
        }
        if (this.ticks % 2 == 0) {
            this.addParticle(new Particle(this.bird.getCenterPos(), ParticleColor.WHITE, 9, ParticleLevel.RUNNING_GAME)).setVelocity(new class_241(-2.5f, 0.0f));
        }
        --this.pipeSpawnTimer;
    }

    @Override
    public synchronized void die() {
        super.die();
        this.bird.hide();
        this.spawnParticleExplosion(() -> new BreakParticleRenderer(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/bird.png"), 10, 32), this.bird.getCenterPos(), 20, 2, 10, ParticleLevel.GAME);
    }

    private void spawnPipe() {
        int holeSize = this.random.nextInt(24, 28);
        int hole = this.random.nextInt(5, 100 - holeSize - 21);
        this.pipes.add(new Sprite(new class_241(140.0f, (float)hole - 64.0f), new class_241(16.0f, 64.0f), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/pipe_top.png")));
        this.pipes.get(this.pipes.size() - 1).setVelocity(new class_241(-2.5f, 0.0f));
        this.pipes.add(new Sprite(new class_241(140.0f, (float)hole + (float)holeSize), new class_241(16.0f, 64.0f), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/pipe_bottom.png")));
        this.pipes.get(this.pipes.size() - 1).setVelocity(new class_241(-2.5f, 0.0f));
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        if (this.bird != null) {
            this.bird.render(graphics, posX, posY);
        }
        for (Sprite pillar : this.pipes) {
            pillar.render(graphics, posX, posY);
        }
        this.ground.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (button.isActionButton()) {
            this.bird.setVelocity(new class_241(0.0f, -4.5f));
            if (this.stage == GameStage.PLAYING) {
                this.soundPlayer.playJump();
            }
        }
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/flappy_bird_background.png");
    }

    @Override
    public boolean showScoreBox() {
        return false;
    }

    @Override
    public int scoreColor() {
        return class_124.field_1054.method_532();
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.flappy_bird");
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_flappy_bird.png");
    }
}

