/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class GobangGameAiEdition
extends Game {
    private static final class_2960 SELECT = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/select.png");
    private static final class_2960 RIVAL_SELECT = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rival_select.png");
    private final MultiImage PIECES = new MultiImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/pieces.png"), 8, 24, 3);
    private static final int GAME_WIDTH = 16;
    private static final int GAME_HEIGHT = 12;
    private static final int NOTHING = 0;
    private static final int WHITE = 1;
    private static final int BLACK = 2;
    private int aiRetryCount = 0;
    private boolean isWhiteTurn;
    private static final int TILE_SIZE = 8;
    private static final class_241 GAME_POS = new class_241(7.0f, 3.0f);
    private Grid grid = new Grid(16, 12, 8, this.PIECES);
    private class_241 selectionPos = VecUtil.round(new class_241(15.0f, 11.0f).method_35582(0.5f));
    private final Sprite selection = new Sprite(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)), VecUtil.of(10.0f), new Image(SELECT, 8, 8));
    private final Sprite selection2 = new Sprite(this.calcPos(this.selectionPos.method_35585(-4.0f)).method_35586(VecUtil.of(-1.0f)), VecUtil.of(10.0f), new Image(RIVAL_SELECT, 8, 8));

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.selection.show();
        this.grid = new Grid(16, 12, 8, this.PIECES);
        this.isWhiteTurn = true;
    }

    @Override
    public synchronized void start() {
        super.start();
        this.selection2.show();
    }

    private class_241 calcPos(class_241 tile) {
        return tile.method_35582(8.0f).method_35586(GAME_POS);
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if (this.stage != GameStage.PLAYING) {
            return;
        }
        if (this.ticks % 2 == 0 && this.isWhiteTurn) {
            if (this.controls.isButtonDown(Button.UP) && !this.controls.wasButtonDown(Button.UP)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_UP);
            }
            if (this.controls.isButtonDown(Button.DOWN) && !this.controls.wasButtonDown(Button.DOWN)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_DOWN);
            }
            if (this.controls.isButtonDown(Button.LEFT) && !this.controls.wasButtonDown(Button.LEFT)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_LEFT);
            }
            if (this.controls.isButtonDown(Button.RIGHT) && !this.controls.wasButtonDown(Button.RIGHT)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new class_241(Math.min(Math.max(this.selectionPos.field_1343, 0.0f), 15.0f), Math.min(Math.max(this.selectionPos.field_1342, 0.0f), 11.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
        }
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        if (this.stage == GameStage.PLAYING && this.ticks % 15 == 0 && !this.isWhiteTurn) {
            ArrayList<class_241> emptySlots = new ArrayList<class_241>();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 12; ++y) {
                    if (this.grid.get(x, y) != 0) continue;
                    emptySlots.add(new class_241((float)x, (float)y));
                }
            }
            if (!emptySlots.isEmpty()) {
                class_241 aiMove = this.findBestMove();
                if (aiMove == null) {
                    aiMove = (class_241)emptySlots.get(0);
                }
                this.grid.set(aiMove, 2);
                this.selection2.setPos(this.calcPos(aiMove).method_35586(VecUtil.of(-1.0f)));
                this.isWhiteTurn = true;
                this.checkResult(2, aiMove);
                this.soundPlayer.play(class_3417.field_37343);
            } else {
                this.die();
            }
        }
    }

    @Override
    public synchronized void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if (this.stage == GameStage.PLAYING || this.stage == GameStage.START) {
            if (button == Button.UP) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_UP);
            }
            if (button == Button.DOWN) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_DOWN);
            }
            if (button == Button.LEFT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_LEFT);
            }
            if (button == Button.RIGHT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new class_241(Math.min(Math.max(this.selectionPos.field_1343, 0.0f), 15.0f), Math.min(Math.max(this.selectionPos.field_1342, 0.0f), 11.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
            if (button == Button.BUTTON1) {
                if (this.stage != GameStage.PLAYING) {
                    this.start();
                }
                if (this.grid.get(this.selectionPos) == 0) {
                    if (this.isWhiteTurn) {
                        this.grid.set(this.selectionPos, 1);
                        this.isWhiteTurn = false;
                        this.checkResult(1, this.selectionPos);
                    }
                    this.soundPlayer.play(class_3417.field_37343);
                }
            }
        } else if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
    }

    @Override
    public synchronized void win() {
        super.win();
        this.selection.hide();
        this.selection2.hide();
    }

    @Override
    public synchronized void die() {
        super.die();
        this.selection.hide();
        this.selection2.hide();
    }

    private void checkResult(int type, class_241 placedPos) {
        int[][] DIRECTIONS;
        for (int[] dir : DIRECTIONS = new int[][]{{1, 0}, {0, 1}, {1, 1}, {1, -1}}) {
            int dx = dir[0];
            int dy = dir[1];
            int count = 1;
            count += this.countDirection(placedPos, dx, dy, type);
            if ((count += this.countDirection(placedPos, -dx, -dy, type)) < 5) continue;
            if (type == 1) {
                this.win();
            } else {
                this.die();
            }
            return;
        }
    }

    private int countDirection(class_241 startPos, int dx, int dy, int type) {
        int count = 0;
        int x = (int)startPos.field_1343 + dx;
        for (int y = (int)startPos.field_1342 + dy; x >= 0 && x < 16 && y >= 0 && y < 12 && this.grid.get(x, y) == type; x += dx, y += dy) {
            ++count;
        }
        return count;
    }

    @Deprecated
    private void checkResult(int type) {
        int i;
        int index;
        int k;
        int j;
        int index2;
        int i2;
        for (i2 = 0; i2 < 16; ++i2) {
            index2 = 0;
            for (j = 0; j < 12; ++j) {
                index2 = this.grid.get(i2, j) == type ? ++index2 : 0;
                if (index2 != 5) continue;
                if (type == 1) {
                    this.win();
                    continue;
                }
                this.die();
            }
        }
        for (i2 = 0; i2 < 12; ++i2) {
            index2 = 0;
            for (j = 0; j < 16; ++j) {
                index2 = this.grid.get(j, i2) == type ? ++index2 : 0;
                if (index2 != 5) continue;
                if (type == 1) {
                    this.win();
                    continue;
                }
                this.die();
            }
        }
        for (k = 0; k < 26; ++k) {
            int startRow = Math.max(0, k - 12 + 1);
            int endRow = Math.min(15, k);
            index = 0;
            for (int i3 = startRow; i3 <= endRow; ++i3) {
                int j2 = k - i3;
                if (j2 < 0 || j2 >= 12) continue;
                index = this.grid.get(i3, j2) == type ? ++index : 0;
                if (index != 5) continue;
                if (type == 1) {
                    this.win();
                    continue;
                }
                this.die();
            }
        }
        for (k = 0; k < 12; ++k) {
            i = 0;
            index = 0;
            for (j = k; i < 16 && j < 12; ++i, ++j) {
                index = this.grid.get(i, j) == type ? ++index : 0;
                if (index != 5) continue;
                if (type == 1) {
                    this.win();
                    continue;
                }
                this.die();
            }
        }
        for (k = 1; k < 16; ++k) {
            i = k;
            index = 0;
            for (j = 0; i < 16 && j < 12; ++i, ++j) {
                index = this.grid.get(i, j) == type ? ++index : 0;
                if (index != 5) continue;
                if (type == 1) {
                    this.win();
                    continue;
                }
                this.die();
            }
        }
    }

    private void resetAIState() {
        this.aiRetryCount = 0;
        this.isWhiteTurn = true;
    }

    private class_241 findBestMove() {
        int maxScore = -1;
        ArrayList<class_241> candidates = new ArrayList<class_241>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 12; ++y) {
                if (this.grid.get(x, y) != 0) continue;
                int score = this.evaluatePosition(x, y);
                if (score > maxScore) {
                    maxScore = score;
                    candidates.clear();
                    candidates.add(new class_241((float)x, (float)y));
                    continue;
                }
                if (score != maxScore) continue;
                candidates.add(new class_241((float)x, (float)y));
            }
        }
        if (!candidates.isEmpty()) {
            this.aiRetryCount = 0;
            return (class_241)candidates.get(this.random.nextInt(candidates.size()));
        }
        if (this.aiRetryCount++ > 3) {
            this.resetAIState();
        }
        return null;
    }

    private int evaluatePosition(int x, int y) {
        int[][] directions;
        int score = 0;
        for (int[] dir : directions = new int[][]{{1, 0}, {0, 1}, {1, 1}, {1, -1}}) {
            score += this.evaluateLine(x, y, dir[0], dir[1], 2);
            score += this.evaluateLine(x, y, dir[0], dir[1], 1) * 2;
        }
        return score;
    }

    private int evaluateLine(int x, int y, int dx, int dy, int type) {
        int cy;
        int count = 0;
        boolean frontOpen = false;
        boolean backOpen = false;
        int cx = x + dx;
        for (cy = y + dy; cx >= 0 && cx < 16 && cy >= 0 && cy < 12; cx += dx, cy += dy) {
            if (this.grid.get(cx, cy) == type) {
                ++count;
                continue;
            }
            frontOpen = this.grid.get(cx, cy) == 0;
            break;
        }
        cx = x - dx;
        for (cy = y - dy; cx >= 0 && cx < 16 && cy >= 0 && cy < 12; cx -= dx, cy -= dy) {
            if (this.grid.get(cx, cy) == type) {
                ++count;
                continue;
            }
            backOpen = this.grid.get(cx, cy) == 0;
            break;
        }
        int openEnds = (frontOpen ? 1 : 0) + (backOpen ? 1 : 0);
        if (count >= 4) {
            return 1000;
        }
        if (count == 3 && openEnds >= 1) {
            return 800;
        }
        if (count == 2 && openEnds >= 2) {
            return 300;
        }
        if (count == 2 && openEnds == 1) {
            return 100;
        }
        return Math.max(1, count * 5 + openEnds * 10);
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.grid.render(graphics, posX + (int)GobangGameAiEdition.GAME_POS.field_1343 - 1, posY + (int)GobangGameAiEdition.GAME_POS.field_1342 - 1);
        this.selection.render(graphics, posX, posY);
        this.selection2.render(graphics, posX, posY);
        if (this.ticks % 20 >= 10) {
            switch (this.stage) {
                case DIED: {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/die_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                    break;
                }
                case WON: {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/win_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                }
            }
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.gobang_ai");
    }

    @Override
    public boolean showPressAnyKey() {
        return false;
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_gobang_ai.png");
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public boolean renderScoreBoard() {
        return false;
    }

    @Override
    public boolean showAiReactInfo() {
        return true;
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/gobang_background.png");
    }
}

