/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class GobangGamePlayerEdition
extends Game {
    private static final class_2960 SELECT = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/select.png");
    private static final class_2960 RIVAL_SELECT = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rival_select.png");
    private final MultiImage PIECES = new MultiImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/pieces.png"), 8, 24, 3);
    private static final int GAME_WIDTH = 16;
    private static final int GAME_HEIGHT = 12;
    private static final int NOTHING = 0;
    private static final int WHITE = 1;
    private static final int BLACK = 2;
    private boolean isWhiteTurn;
    private static final int TILE_SIZE = 8;
    private static final class_241 GAME_POS = new class_241(7.0f, 3.0f);
    private Grid grid = new Grid(16, 12, 8, this.PIECES);
    private class_241 selectionPos = VecUtil.round(new class_241(15.0f, 11.0f).method_35582(0.5f));
    private final Sprite selection = new Sprite(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)), VecUtil.of(10.0f), new Image(SELECT, 8, 8));
    private final Sprite selection2 = new Sprite(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)), VecUtil.of(10.0f), new Image(RIVAL_SELECT, 8, 8));

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.selection.show();
        this.selection2.hide();
        this.grid = new Grid(16, 12, 8, this.PIECES);
        this.isWhiteTurn = true;
    }

    private class_241 calcPos(class_241 tile) {
        return tile.method_35582(8.0f).method_35586(GAME_POS);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if (this.stage == GameStage.PLAYING || this.stage == GameStage.START) {
            if (button == Button.UP) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_UP);
            }
            if (button == Button.DOWN) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_DOWN);
            }
            if (button == Button.LEFT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_LEFT);
            }
            if (button == Button.RIGHT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new class_241(Math.min(Math.max(this.selectionPos.field_1343, 0.0f), 15.0f), Math.min(Math.max(this.selectionPos.field_1342, 0.0f), 11.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
            this.selection2.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
            if (button == Button.BUTTON1) {
                if (this.stage != GameStage.PLAYING) {
                    this.start();
                }
                if (this.grid.get(this.selectionPos) == 0) {
                    if (this.isWhiteTurn) {
                        this.selection.hide();
                        this.selection2.show();
                        this.grid.set(this.selectionPos, 1);
                        this.isWhiteTurn = false;
                        this.checkResult(1, this.selectionPos);
                    } else {
                        this.selection.show();
                        this.selection2.hide();
                        this.grid.set(this.selectionPos, 2);
                        this.isWhiteTurn = true;
                        this.checkResult(2, this.selectionPos);
                    }
                    this.soundPlayer.play(class_3417.field_37343);
                }
            }
        } else if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
    }

    @Override
    public synchronized void win() {
        super.win();
        this.selection.hide();
    }

    @Override
    public synchronized void die() {
        super.die();
        this.selection.hide();
    }

    private void checkResult(int type, class_241 placedPos) {
        int[][] DIRECTIONS;
        for (int[] dir : DIRECTIONS = new int[][]{{1, 0}, {0, 1}, {1, 1}, {1, -1}}) {
            int dx = dir[0];
            int dy = dir[1];
            int count = 1;
            count += this.countDirection(placedPos, dx, dy, type);
            if ((count += this.countDirection(placedPos, -dx, -dy, type)) < 5) continue;
            if (type == 1) {
                this.win();
            } else {
                this.die();
            }
            return;
        }
    }

    private int countDirection(class_241 startPos, int dx, int dy, int type) {
        int count = 0;
        int x = (int)startPos.field_1343 + dx;
        for (int y = (int)startPos.field_1342 + dy; x >= 0 && x < 16 && y >= 0 && y < 12 && this.grid.get(x, y) == type; x += dx, y += dy) {
            ++count;
        }
        return count;
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.grid.render(graphics, posX + (int)GobangGamePlayerEdition.GAME_POS.field_1343 - 1, posY + (int)GobangGamePlayerEdition.GAME_POS.field_1342 - 1);
        this.selection.render(graphics, posX, posY);
        this.selection2.render(graphics, posX, posY);
        if (this.ticks % 20 >= 10) {
            switch (this.stage) {
                case DIED: {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/die_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                    break;
                }
                case WON: {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/win_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                }
            }
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.gobang");
    }

    @Override
    public boolean showPressAnyKey() {
        return false;
    }

    @Override
    public boolean showMutiPlayerInfo() {
        return true;
    }

    @Override
    public boolean renderScoreBoard() {
        return false;
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_gobang.png");
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/gobang_background.png");
    }
}

