/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid2048;
import net.tejty.gamediscs.games.util.Grid2048Slot;

public class Grid2048Game
extends Game {
    private static final int COLUMN_1 = 27;
    private static final int COLUMN_2 = 49;
    private static final int COLUMN_3 = 71;
    private static final int COLUMN_4 = 93;
    private static final int[] COLUMNS = new int[]{27, 49, 71, 93};
    private static final int ROW_1 = 13;
    private static final int ROW_2 = 35;
    private static final int ROW_3 = 57;
    private static final int ROW_4 = 79;
    private static final int[] ROWS = new int[]{13, 35, 57, 79};
    private final List<Grid2048Slot> grids = new ArrayList<Grid2048Slot>();
    private int moveCooldown = 0;

    @Override
    public synchronized void prepare() {
        for (int row : ROWS) {
            for (int column : COLUMNS) {
                this.grids.add(new Grid2048Slot(new class_241((float)column, (float)row), new class_241(16.0f, 16.0f), Grid2048.NO_GRID));
            }
        }
        super.prepare();
    }

    @Override
    public synchronized void die() {
        this.grids.clear();
        this.soundPlayer.playGameOver();
        super.die();
    }

    @Override
    public synchronized void win() {
        this.grids.clear();
        this.spawnConfetti();
        this.soundPlayer.playNewBest();
        super.win();
    }

    @Override
    public synchronized void start() {
        super.start();
        int init1 = this.random.nextInt(this.grids.size());
        int init2 = this.random.nextInt(this.grids.size());
        this.grids.set(init1, this.grids.get(init1).setGrid2048(Grid2048.GRID_2));
        this.grids.set(init2, this.grids.get(init2).setGrid2048(Grid2048.GRID_2));
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        if (this.moveCooldown < 2) {
            ++this.moveCooldown;
        }
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        for (Grid2048Slot slot : this.grids) {
            slot.render(graphics, posX, posY);
        }
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (this.stage == GameStage.PLAYING && this.ticks > 5 && this.moveCooldown >= 2) {
            switch (button) {
                case LEFT: {
                    if (!this.moveLeft()) break;
                    this.soundPlayer.playPoint();
                    this.moveCooldown = 0;
                    this.spawnNewTile();
                    this.checkWin();
                    if (!this.isGameOver()) break;
                    this.die();
                    break;
                }
                case RIGHT: {
                    if (!this.moveRight()) break;
                    this.soundPlayer.playPoint();
                    this.moveCooldown = 0;
                    this.spawnNewTile();
                    this.checkWin();
                    if (!this.isGameOver()) break;
                    this.die();
                    break;
                }
                case UP: {
                    if (!this.moveUp()) break;
                    this.soundPlayer.playPoint();
                    this.moveCooldown = 0;
                    this.spawnNewTile();
                    this.checkWin();
                    if (!this.isGameOver()) break;
                    this.die();
                    break;
                }
                case DOWN: {
                    if (!this.moveDown()) break;
                    this.soundPlayer.playPoint();
                    this.moveCooldown = 0;
                    this.spawnNewTile();
                    this.checkWin();
                    if (!this.isGameOver()) break;
                    this.die();
                    break;
                }
                default: {
                    this.moveCooldown = 0;
                }
            }
        }
    }

    private boolean moveLeft() {
        boolean moved = false;
        for (int row = 0; row < 4; ++row) {
            int[] currentRow = new int[4];
            for (int col = 0; col < 4; ++col) {
                currentRow[col] = this.grids.get(row * 4 + col).getGrid2048().getValue();
            }
            int[] newRow = this.processLine(currentRow, false);
            if (Arrays.equals(currentRow, newRow)) continue;
            moved = true;
            for (int col = 0; col < 4; ++col) {
                Grid2048Slot slot = this.grids.get(row * 4 + col);
                Grid2048 newGrid = Grid2048.get(newRow[col]);
                this.grids.set(row * 4 + col, slot.setGrid2048(newGrid));
            }
        }
        return moved;
    }

    private boolean moveRight() {
        boolean moved = false;
        for (int row = 0; row < 4; ++row) {
            int[] currentRow = new int[4];
            for (int col = 0; col < 4; ++col) {
                currentRow[col] = this.grids.get(row * 4 + col).getGrid2048().getValue();
            }
            int[] newRow = this.processLine(currentRow, true);
            if (Arrays.equals(currentRow, newRow)) continue;
            moved = true;
            for (int col = 0; col < 4; ++col) {
                Grid2048Slot slot = this.grids.get(row * 4 + col);
                Grid2048 newGrid = Grid2048.get(newRow[col]);
                this.grids.set(row * 4 + col, slot.setGrid2048(newGrid));
            }
        }
        return moved;
    }

    private boolean moveUp() {
        boolean moved = false;
        for (int col = 0; col < 4; ++col) {
            int[] currentCol = new int[4];
            for (int row = 0; row < 4; ++row) {
                currentCol[row] = this.grids.get(row * 4 + col).getGrid2048().getValue();
            }
            int[] newCol = this.processLine(currentCol, false);
            if (Arrays.equals(currentCol, newCol)) continue;
            moved = true;
            for (int row = 0; row < 4; ++row) {
                Grid2048Slot slot = this.grids.get(row * 4 + col);
                Grid2048 newGrid = Grid2048.get(newCol[row]);
                this.grids.set(row * 4 + col, slot.setGrid2048(newGrid));
            }
        }
        return moved;
    }

    private boolean moveDown() {
        boolean moved = false;
        for (int col = 0; col < 4; ++col) {
            int[] currentCol = new int[4];
            for (int row = 0; row < 4; ++row) {
                currentCol[row] = this.grids.get(row * 4 + col).getGrid2048().getValue();
            }
            int[] newCol = this.processLine(currentCol, true);
            if (Arrays.equals(currentCol, newCol)) continue;
            moved = true;
            for (int row = 0; row < 4; ++row) {
                Grid2048Slot slot = this.grids.get(row * 4 + col);
                Grid2048 newGrid = Grid2048.get(newCol[row]);
                this.grids.set(row * 4 + col, slot.setGrid2048(newGrid));
            }
        }
        return moved;
    }

    private int[] processLine(int[] line, boolean reverse) {
        ArrayList<Integer> nonZero = new ArrayList<Integer>();
        for (int num : line) {
            if (num == 0) continue;
            nonZero.add(num);
        }
        if (reverse) {
            Collections.reverse(nonZero);
        }
        ArrayList<Integer> merged = new ArrayList<Integer>();
        int i = 0;
        while (i < nonZero.size()) {
            if (i + 1 < nonZero.size() && ((Integer)nonZero.get(i)).equals(nonZero.get(i + 1))) {
                merged.add((Integer)nonZero.get(i) * 2);
                this.score += (Integer)nonZero.get(i) * 2;
                i += 2;
                continue;
            }
            merged.add((Integer)nonZero.get(i));
            ++i;
        }
        int[] newLine = new int[4];
        if (reverse) {
            index = 3;
            Iterator iterator = merged.iterator();
            while (iterator.hasNext()) {
                int num = (Integer)iterator.next();
                if (index >= 0) {
                    newLine[index--] = num;
                    continue;
                }
                break;
            }
        } else {
            index = 0;
            Iterator iterator = merged.iterator();
            while (iterator.hasNext()) {
                int num = (Integer)iterator.next();
                if (index < 4) {
                    newLine[index++] = num;
                    continue;
                }
                break;
            }
        }
        return newLine;
    }

    private void checkWin() {
        for (Grid2048Slot slot : this.grids) {
            if (slot.getGrid2048() != Grid2048.GRID_2048) continue;
            this.win();
            break;
        }
    }

    private boolean isGameOver() {
        boolean hasEmpty = this.grids.stream().anyMatch(slot -> slot.getGrid2048() == Grid2048.NO_GRID);
        if (hasEmpty) {
            return false;
        }
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                Grid2048 current = this.grids.get(row * 4 + col).getGrid2048();
                if (col < 3 && current == this.grids.get(row * 4 + col + 1).getGrid2048()) {
                    return false;
                }
                if (row >= 3 || current != this.grids.get((row + 1) * 4 + col).getGrid2048()) continue;
                return false;
            }
        }
        return true;
    }

    private void spawnNewTile() {
        List<Grid2048Slot> emptySlots = this.grids.stream().filter(slot -> slot.getGrid2048() == Grid2048.NO_GRID).toList();
        if (!emptySlots.isEmpty()) {
            Grid2048Slot slot2 = emptySlots.get(this.random.nextInt(emptySlots.size()));
            Grid2048 newGrid = (double)this.random.nextFloat() < 0.9 ? Grid2048.GRID_2 : Grid2048.GRID_4;
            this.grids.set(this.grids.indexOf(slot2), slot2.setGrid2048(newGrid));
        }
    }

    @Override
    public boolean useLongScoreBox() {
        return true;
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_grid_2048.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.grid_2048");
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/grid_2048_background.png");
    }
}

