/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Sprite;

public class PlaneWarGame
extends Game {
    private static final float PLAYER_SPEED = 3.0f;
    private static final float BULLET_SPEED = -6.0f;
    private static final int ROCK_SPAWN_INTERVAL = 30;
    private static final int ROCK_MIN_SPEED = 1;
    private static final int ROCK_MAX_SPEED = 4;
    private Sprite player;
    private List<Sprite> rocks = new ArrayList<Sprite>();
    private List<Sprite> bullets = new ArrayList<Sprite>();
    private int rockSpawnTimer = 0;
    private static final class_2960 PLAYER_IMG = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/plane.png");
    private static final class_2960 BULLET_IMG = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/bullet.png");
    private static final class_2960[] ROCK_IMAGES = new class_2960[]{class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rock.png"), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rock0.png"), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rock1.png"), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rock2.png"), class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/rock3.png")};

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.player = new Sprite(new class_241(62.0f, 70.0f), new class_241(16.0f, 16.0f), new Image(PLAYER_IMG, 16, 16));
        this.rocks.clear();
        this.bullets.clear();
        this.rockSpawnTimer = 30;
    }

    @Override
    public synchronized void gameTick() {
        int i;
        super.gameTick();
        if (this.stage != GameStage.PLAYING) {
            return;
        }
        if (this.controls.isButtonDown(Button.LEFT)) {
            this.player.moveBy(new class_241(-3.0f, 0.0f));
        }
        if (this.controls.isButtonDown(Button.RIGHT)) {
            this.player.moveBy(new class_241(3.0f, 0.0f));
        }
        if (this.player.getX() < 0.0f) {
            this.player.setX(0.0f);
        }
        if (this.player.getX() > 140.0f - this.player.getWidth()) {
            this.player.setX(140.0f - this.player.getWidth());
        }
        for (i = 0; i < this.bullets.size(); ++i) {
            Sprite bullet = this.bullets.get(i);
            bullet.moveBy(new class_241(0.0f, -6.0f));
            if (!(bullet.getY() < -bullet.getHeight())) continue;
            this.bullets.remove(i);
            --i;
        }
        for (i = 0; i < this.rocks.size(); ++i) {
            Sprite rock = this.rocks.get(i);
            rock.tick();
            if (this.player.isTouching(rock)) {
                this.die();
                return;
            }
            for (int j = 0; j < this.bullets.size(); ++j) {
                Sprite bullet = this.bullets.get(j);
                if (!bullet.isTouching(rock)) continue;
                this.rocks.remove(i);
                this.soundPlayer.play(class_3417.field_15239);
                this.bullets.remove(j);
                ++this.score;
                this.soundPlayer.playPoint();
                --i;
                break;
            }
            if (!(rock.getY() > 100.0f)) continue;
            this.rocks.remove(i);
            --i;
        }
        if (this.rockSpawnTimer-- <= 0) {
            this.spawnRock();
            this.spawnRock();
            this.spawnRock();
            this.spawnRock();
            this.spawnRock();
            this.rockSpawnTimer = 30;
        }
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (button == Button.BUTTON1 && this.stage == GameStage.PLAYING) {
            Sprite bullet = new Sprite(new class_241(this.player.getX() + this.player.getWidth() / 2.0f - 4.0f, this.player.getY() - 8.0f), new class_241(8.0f, 8.0f), new Image(BULLET_IMG, 8, 8));
            bullet.setVelocity(new class_241(0.0f, -6.0f));
            this.bullets.add(bullet);
            this.soundPlayer.play(class_3417.field_14600);
            this.soundPlayer.playClick(true);
        }
    }

    private void spawnRock() {
        class_2960 rockImg = ROCK_IMAGES[this.random.nextInt(ROCK_IMAGES.length)];
        Sprite rock = new Sprite(new class_241((float)this.random.nextInt(120), -20.0f), new class_241(16.0f, 16.0f), new Image(rockImg, 16, 16));
        rock.setVelocity(new class_241(this.random.nextFloat() * 2.0f - 1.0f, (float)(this.random.nextInt(3) + 1)));
        this.rocks.add(rock);
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        if (this.player != null) {
            this.player.render(graphics, posX, posY);
        }
        for (Sprite bullet : this.bullets) {
            bullet.render(graphics, posX, posY);
        }
        for (Sprite rock : this.rocks) {
            rock.render(graphics, posX, posY);
        }
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_plane_war.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.plane_war");
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/universe_background.png");
    }

    @Override
    public int scoreColor() {
        return 0xFFFF00;
    }

    @Override
    public boolean showScoreBox() {
        return false;
    }
}

