/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class PongGame
extends Game {
    private Sprite player = new Sprite(new class_241(10.0f, 40.0f), new class_241(5.0f, 20.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png"));
    private Sprite oponent = new Sprite(new class_241(125.0f, 40.0f), new class_241(5.0f, 20.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png"));
    private Sprite ball = new Sprite(new class_241(68.0f, 48.0f), new class_241(4.0f, 4.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png"));
    private Sprite numberRenderer = new Sprite(new class_241(0.0f, 0.0f), new class_241(8.0f, 12.0f), new MultiImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/numbers.png"), 8, 120, 10));
    private static final int SPEED = 3;
    private int oponentScore = 0;
    private int ballTimer;
    private float ballSpeed = 3.0f;

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.player = new Sprite(new class_241(10.0f, 40.0f), new class_241(5.0f, 20.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png"));
        this.oponent = new Sprite(new class_241(125.0f, 40.0f), new class_241(5.0f, 20.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png"));
        this.ballSpeed = 4.0f;
        this.ball = new Sprite(new class_241(68.0f, 48.0f), new class_241(4.0f, 4.0f), class_2960.method_60654((String)"minecraft:textures/block/white_concrete.png")).setVelocity(new class_241((float)((this.random.nextInt(2) * 2 - 1) * 2), (float)((this.random.nextInt(2) * 2 - 1) * 2)));
        this.oponentScore = 0;
    }

    public void resetBall() {
        this.ballSpeed = 4.0f;
        this.ball.setPos(new class_241(68.0f, 48.0f));
        this.ball.setVelocity(new class_241((float)(this.random.nextInt(2) * 2 - 1), (float)(this.random.nextInt(2) * 2 - 1)).method_35581().method_35582(this.ballSpeed));
        this.ballTimer = 60;
    }

    @Override
    public synchronized void start() {
        super.start();
        this.ballTimer = 60;
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if (this.ballTimer > 0) {
            --this.ballTimer;
        }
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        if (this.ticks % 20 == 0) {
            this.ballSpeed += 0.1f;
        }
        if (this.controls.isButtonDown(Button.UP)) {
            this.player.moveBy(VecUtil.VEC_UP.method_35582(3.0f));
        }
        if (this.controls.isButtonDown(Button.DOWN)) {
            this.player.moveBy(VecUtil.VEC_DOWN.method_35582(3.0f));
        }
        if (this.ball.getCenterPos().field_1342 < this.oponent.getCenterPos().field_1342) {
            this.oponent.moveBy(VecUtil.VEC_UP.method_35582(3.0f));
        }
        if (this.ball.getCenterPos().field_1342 > this.oponent.getCenterPos().field_1342) {
            this.oponent.moveBy(VecUtil.VEC_DOWN.method_35582(3.0f));
        }
        this.player.setY(Math.min(Math.max(this.player.getY(), 0.0f), 100.0f - this.player.getHeight()));
        this.oponent.setY(Math.min(Math.max(this.oponent.getY(), 0.0f), 100.0f - this.oponent.getHeight()));
        if (this.ballTimer <= 0) {
            this.ball.moveBy(new class_241(this.ball.getVelocity().field_1343, 0.0f));
            if (this.ball.getX() < 0.0f) {
                ++this.oponentScore;
                this.resetBall();
            }
            if (this.ball.getX() + this.ball.getWidth() > 140.0f) {
                ++this.score;
                this.soundPlayer.playPoint();
                this.resetBall();
            }
            if (this.ballTimer <= 0) {
                this.ball.moveBy(new class_241(0.0f, this.ball.getVelocity().field_1342));
                if (this.ball.getY() < 0.0f || this.ball.getY() + this.ball.getHeight() > 100.0f) {
                    this.ball.moveBy(new class_241(0.0f, -this.ball.getVelocity().field_1342));
                    this.ball.setVelocity(new class_241(this.ball.getVelocity().field_1343, -this.ball.getVelocity().field_1342));
                    this.soundPlayer.playJump();
                }
                if (this.ball.isTouching(this.player)) {
                    this.ball.setVelocity(this.ball.getCenterPos().method_35586(this.player.getCenterPos().method_35586(new class_241(-2.0f, 0.0f)).method_35588()).method_35581().method_35582(this.ballSpeed));
                    this.soundPlayer.playJump();
                }
                if (this.ball.isTouching(this.oponent)) {
                    this.ball.setVelocity(this.ball.getCenterPos().method_35586(this.oponent.getCenterPos().method_35586(new class_241(2.0f, 0.0f)).method_35588()).method_35581().method_35582(this.ballSpeed));
                    this.soundPlayer.playJump();
                }
            }
        }
        if (this.score >= 10) {
            this.win();
        }
        if (this.oponentScore >= 10) {
            this.die();
        }
    }

    @Override
    public synchronized void die() {
        super.die();
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        MultiImage image;
        Renderer renderer;
        super.render(graphics, posX, posY);
        this.player.render(graphics, posX, posY);
        this.oponent.render(graphics, posX, posY);
        this.ball.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        if (this.score < 10) {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(this.score);
            }
            this.numberRenderer.setPos(new class_241(70.0f - this.numberRenderer.getWidth() - 4.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        } else {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(1);
            }
            this.numberRenderer.setPos(new class_241(70.0f - this.numberRenderer.getWidth() * 2.0f - 8.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(0);
            }
            this.numberRenderer.setPos(new class_241(70.0f - this.numberRenderer.getWidth() - 4.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        }
        if (this.oponentScore < 10) {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(this.oponentScore);
            }
            this.numberRenderer.setPos(new class_241(74.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        } else {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(1);
            }
            this.numberRenderer.setPos(new class_241(74.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(0);
            }
            this.numberRenderer.setPos(new class_241(70.0f + this.numberRenderer.getWidth() + 8.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/pong_background.png");
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.pong");
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_pong_no_anim.png");
    }
}

