/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.graphics.DirectionalImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class SlimeGame
extends Game {
    private final DirectionalImage HEAD = new DirectionalImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/slime_head.png"), 8, 32);
    private final DirectionalImage TAIL = new DirectionalImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/slime_tail.png"), 8, 32);
    private final DirectionalImage CONNECTION = new DirectionalImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/slime_connection.png"), 8, 32);
    private static final class_2960 BODY = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/slime_body.png");
    private static final class_2960 APPLE = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/apple.png");
    private static final class_241 GAME_POS = new class_241(6.0f, 2.0f);
    private static final int TILE_SIZE = 8;
    private static final int GAME_WIDTH = 16;
    private static final int GAME_HEIGHT = 12;
    private static final List<class_241> BLOCKED = List.of(new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(2.0f, 0.0f), new class_241(3.0f, 0.0f), new class_241(4.0f, 0.0f), new class_241(5.0f, 0.0f), new class_241(6.0f, 0.0f));
    private List<class_241> slime = new ArrayList<class_241>();
    private class_241 direction = VecUtil.VEC_RIGHT;
    private final Sprite slimeRenderer = new Sprite(class_241.field_1340, new class_241(8.0f, 8.0f), BODY);
    private final Sprite apple = new Sprite(class_241.field_1340, new class_241(8.0f, 8.0f), APPLE);

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.slime = new ArrayList<class_241>();
        this.slime.add(new class_241(5.0f, 5.0f));
        this.slime.add(new class_241(6.0f, 5.0f));
        this.slime.add(new class_241(7.0f, 5.0f));
        this.respawnApple();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.direction = VecUtil.VEC_RIGHT;
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        class_241 newPos = this.slime.get(this.slime.size() - 1).method_35586(this.direction);
        if (newPos.field_1343 >= 16.0f || newPos.field_1343 < 0.0f || newPos.field_1342 >= 12.0f || newPos.field_1342 < 0.0f) {
            this.die();
        }
        for (int i = 0; i < this.slime.size(); ++i) {
            class_241 part = this.slime.get(i);
            if (i == 0 || !VecUtil.is(part, newPos)) continue;
            this.die();
        }
        for (class_241 block : BLOCKED) {
            if (!VecUtil.is(block, newPos)) continue;
            this.die();
        }
        if (this.stage == GameStage.PLAYING) {
            this.slime.add(newPos);
            if (!VecUtil.is(newPos, this.calcTile(this.apple.getPos()))) {
                this.slime.remove(this.slime.get(0));
            } else {
                this.spawnParticleExplosion(() -> new BreakParticleRenderer(APPLE, 8, 8), this.apple.getCenterPos(), 15, 3, 5, ParticleLevel.GAME);
                this.respawnApple();
                ++this.score;
                this.soundPlayer.play(class_3417.field_20614);
            }
        }
        this.addParticle(new Particle(this.calcPos(this.slime.get(0).method_35586(VecUtil.randomFloat(class_241.field_1340, new class_241(1.0f, 1.0f), this.random))), new BreakParticleRenderer(BODY, 8, 8), this.random.nextInt(20, 50), ParticleLevel.RUNNING_GAME));
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.apple.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        for (int i = this.slime.size() - 1; i >= 0; --i) {
            if (i == 0) {
                this.slimeRenderer.setImage(this.TAIL.setImage(VecUtil.get4DirectionTo(this.slime.get(0), this.slime.get(1))));
            } else if (i == this.slime.size() - 1) {
                this.slimeRenderer.setImage(this.HEAD.setImage(VecUtil.get4DirectionTo(this.slime.get(this.slime.size() - 2), this.slime.get(this.slime.size() - 1))));
            } else {
                this.slimeRenderer.setImage(BODY);
            }
            class_241 part = this.slime.get(i);
            this.slimeRenderer.setPos(this.calcPos(part));
            this.slimeRenderer.render(graphics, posX, posY);
            if (i + 1 >= this.slime.size()) continue;
            this.slimeRenderer.setPos(this.calcPos(part.method_35586(VecUtil.getFrom(VecUtil.get4DirectionTo(part, this.slime.get(i + 1))).method_35582(0.5f))));
            this.slimeRenderer.setImage(this.CONNECTION.setImage(VecUtil.get4DirectionTo(part, this.slime.get(i + 1))));
            this.slimeRenderer.render(graphics, posX, posY);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    private void respawnApple() {
        boolean valid = false;
        block0: while (!valid) {
            this.apple.setPos(this.calcPos(VecUtil.randomInt(class_241.field_1340, new class_241(16.0f, 12.0f), this.random)));
            valid = true;
            class_241 applePos = this.calcTile(this.apple.getPos());
            for (class_241 Vec2f : this.slime) {
                if (!VecUtil.is(Vec2f, applePos)) continue;
                valid = false;
                break;
            }
            for (class_241 block : BLOCKED) {
                if (!VecUtil.is(block, applePos)) continue;
                valid = false;
                continue block0;
            }
        }
    }

    private class_241 calcTile(class_241 pos) {
        return pos.method_35586(GAME_POS.method_35588()).method_35582(0.125f);
    }

    private class_241 calcPos(class_241 tile) {
        return tile.method_35582(8.0f).method_35586(GAME_POS);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (this.stage == GameStage.PLAYING) {
            class_241 oldDirection = this.direction;
            switch (button) {
                case UP: {
                    if (this.direction == VecUtil.VEC_DOWN) {
                        return;
                    }
                    this.direction = VecUtil.VEC_UP;
                    break;
                }
                case RIGHT: {
                    if (this.direction == VecUtil.VEC_LEFT) {
                        return;
                    }
                    this.direction = VecUtil.VEC_RIGHT;
                    break;
                }
                case DOWN: {
                    if (this.direction == VecUtil.VEC_UP) {
                        return;
                    }
                    this.direction = VecUtil.VEC_DOWN;
                    break;
                }
                case LEFT: {
                    if (this.direction == VecUtil.VEC_RIGHT) {
                        return;
                    }
                    this.direction = VecUtil.VEC_LEFT;
                }
            }
            if (!VecUtil.is(oldDirection, this.direction)) {
                this.soundPlayer.play(class_3417.field_15095, 0.1f, 0.5f);
            }
        }
    }

    @Override
    public int gameTickDuration() {
        return 5;
    }

    @Override
    public class_2960 getBackground() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/slime_background.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.slime");
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_slime.png");
    }
}

