/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class TntSweeperGame
extends Game {
    private final MultiImage TILE = new MultiImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/tnt_sweeper.png"), 6, 84, 14);
    private final MultiImage TILE2 = new MultiImage(class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/tnt_sweeper2.png"), 6, 84, 14);
    private static final class_2960 SELECT = class_2960.method_60655((String)"gamediscs", (String)"textures/games/sprite/select.png");
    private static final class_241 GAME_POS = new class_241(1.0f, 9.0f);
    private static final int TILE_SIZE = 6;
    private static final int GAME_WIDTH = 23;
    private static final int GAME_HEIGHT = 15;
    private static final int TNT_COUNT = 70;
    private int flags;
    private boolean useGardenTexture = true;
    private static final class_310 mc = class_310.method_1551();
    private List<class_241> bombs = new ArrayList<class_241>();
    private Grid grid;
    private static final int NOTHING = 0;
    private static final int FLAG = 1;
    private static final int EMPTY = 2;
    private static final int ONE = 3;
    private static final int TWO = 4;
    private static final int THREE = 5;
    private static final int FOUR = 6;
    private static final int FIVE = 7;
    private static final int SIX = 8;
    private static final int SEVEN = 9;
    private static final int EIGHT = 10;
    private static final int TNT = 11;
    private static final int BLOWN_TNT = 12;
    private static final int WRONG_FLAG = 13;
    private class_241 selectionPos = VecUtil.round(new class_241(22.0f, 14.0f).method_35582(0.5f));
    private final Sprite selection = new Sprite(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)), VecUtil.of(8.0f), new Image(SELECT, 8, 8));

    private boolean isTntOn(class_241 pos) {
        for (class_241 bomb : this.bombs) {
            if (!VecUtil.is(bomb, pos)) continue;
            return true;
        }
        return false;
    }

    private int calculateBombsAround(class_241 pos) {
        int count = 0;
        for (class_241 rel : VecUtil.RELATIVES) {
            if (!this.isTntOn(pos.method_35586(rel))) continue;
            ++count;
        }
        return count;
    }

    private static int numberTile(int number) {
        return number + 2;
    }

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.useGardenTexture = !this.useGardenTexture;
        this.grid = new Grid(23, 15, 6, this.useGardenTexture ? this.TILE2 : this.TILE);
        this.bombs = new ArrayList<class_241>();
        this.flags = 70;
    }

    @Override
    public synchronized void start() {
        super.start();
        for (int i = 0; i < 70; ++i) {
            class_241 pos = null;
            while (pos == null || this.isTntOn(pos) || !(Math.sqrt(pos.method_35589(this.selectionPos)) > 2.0)) {
                pos = VecUtil.randomInt(class_241.field_1340, new class_241(23.0f, 15.0f), this.random);
            }
            this.bombs.add(pos);
        }
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if ((this.stage == GameStage.PLAYING || this.stage == GameStage.START) && this.ticks % 2 == 0) {
            if (this.controls.isButtonDown(Button.UP) && !this.controls.wasButtonDown(Button.UP)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_UP);
            }
            if (this.controls.isButtonDown(Button.DOWN) && !this.controls.wasButtonDown(Button.DOWN)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_DOWN);
            }
            if (this.controls.isButtonDown(Button.LEFT) && !this.controls.wasButtonDown(Button.LEFT)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_LEFT);
            }
            if (this.controls.isButtonDown(Button.RIGHT) && !this.controls.wasButtonDown(Button.RIGHT)) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new class_241(Math.min(Math.max(this.selectionPos.field_1343, 0.0f), 22.0f), Math.min(Math.max(this.selectionPos.field_1342, 0.0f), 14.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
        }
    }

    @Override
    public synchronized void render(class_332 graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.grid.render(graphics, posX + (int)TntSweeperGame.GAME_POS.field_1343, posY + (int)TntSweeperGame.GAME_POS.field_1342);
        this.selection.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
        class_327 font = class_310.method_1551().field_1772;
        String text = String.valueOf(this.flags);
        graphics.method_51433(font, text, posX + 2, posY + 2, 0x373737, false);
        graphics.method_51433(font, text, posX + 1, posY + 1, 0xFFFFFF, false);
        if (this.stage == GameStage.PLAYING) {
            text = String.valueOf(this.ticks / 20);
            graphics.method_51433(font, text, posX + 140 - font.method_1727(text) - 1, posY + 2, 0x373737, false);
            graphics.method_51433(font, text, posX + 140 - font.method_1727(text) - 2, posY + 1, 0xFFFFFF, false);
        }
    }

    private class_241 calcTile(class_241 pos) {
        return pos.method_35586(GAME_POS.method_35588()).method_35582(0.16666667f);
    }

    private class_241 calcPos(class_241 tile) {
        return tile.method_35582(6.0f).method_35586(GAME_POS);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if (this.stage == GameStage.PLAYING || this.stage == GameStage.START) {
            if (button == Button.UP) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_UP);
            }
            if (button == Button.DOWN) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_DOWN);
            }
            if (button == Button.LEFT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_LEFT);
            }
            if (button == Button.RIGHT) {
                this.selectionPos = this.selectionPos.method_35586(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new class_241(Math.min(Math.max(this.selectionPos.field_1343, 0.0f), 22.0f), Math.min(Math.max(this.selectionPos.field_1342, 0.0f), 14.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).method_35586(VecUtil.of(-1.0f)));
            if (button == Button.BUTTON2) {
                if (this.grid.get(this.selectionPos) == 0 && this.flags > 0) {
                    this.grid.set(this.selectionPos, 1);
                    --this.flags;
                    this.checkForWin();
                    this.soundPlayer.play(class_3417.field_15226);
                } else if (this.grid.get(this.selectionPos) == 1) {
                    this.grid.set(this.selectionPos, 0);
                    ++this.flags;
                    this.soundPlayer.play(class_3417.field_14983);
                }
            }
        }
        if (this.stage == GameStage.START && button == Button.BUTTON1) {
            this.start();
        }
        if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
        if (this.stage == GameStage.PLAYING && button == Button.BUTTON1) {
            this.dig(this.selectionPos);
        }
    }

    private void dig(class_241 pos) {
        if (this.grid.isIn(pos) && this.grid.get((int)pos.field_1343, (int)pos.field_1342) == 0) {
            if (this.isTntOn(pos)) {
                this.die();
            } else {
                ++this.score;
                this.grid.set((int)pos.field_1343, (int)pos.field_1342, TntSweeperGame.numberTile(this.calculateBombsAround(pos)));
                if (this.grid.get((int)pos.field_1343, (int)pos.field_1342) == 2) {
                    for (class_241 rel : VecUtil.RELATIVES) {
                        this.dig(pos.method_35586(rel));
                    }
                }
                this.soundPlayer.play(class_3417.field_28968);
                this.checkForWin();
            }
        }
    }

    private void checkForWin() {
        if (this.flags == 0 && this.score == 275) {
            this.win();
        }
    }

    @Override
    public synchronized void die() {
        super.die();
        for (class_241 bomb : this.bombs) {
            this.grid.set(bomb, 11);
            this.spawnParticleExplosion(this.calcPos(bomb), 10, 2, 20, ParticleLevel.GAME);
        }
        this.grid.set(this.selectionPos, 12);
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public boolean showPressAnyKey() {
        return false;
    }

    @Override
    public class_2960 getBackground() {
        return this.useGardenTexture ? class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/tnt_sweeper_garden_background.png") : class_2960.method_60655((String)"gamediscs", (String)"textures/games/background/tnt_sweeper_background.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"gamediscs.tnt_sweeper");
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"gamediscs", (String)"textures/item/game_disc_tnt_sweeper.png");
    }
}

