/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_241;
import net.minecraft.class_332;
import net.tejty.gamediscs.games.gamediscs.BlocktrisGame;
import net.tejty.gamediscs.games.util.Grid;

public class BlocktrisPiece {
    private final List<List<class_241>> variants;
    private final BlocktrisGame game;
    private int x;
    private int y;
    private int rotation;
    private int color;
    private final Grid grid;
    private List<class_241> altPositions = List.of(new class_241(0.0f, 1.0f), new class_241(-1.0f, 1.0f), new class_241(1.0f, 1.0f), new class_241(-1.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(0.0f, -1.0f), new class_241(-1.0f, -1.0f), new class_241(1.0f, -1.0f));
    public static final Supplier<List<List<class_241>>> TRIANGLE = () -> List.of(List.of(new class_241(0.0f, 0.0f), new class_241(0.0f, -1.0f), new class_241(1.0f, 0.0f), new class_241(0.0f, 1.0f)), List.of(new class_241(0.0f, 0.0f), new class_241(-1.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(0.0f, 1.0f)), List.of(new class_241(0.0f, 0.0f), new class_241(0.0f, -1.0f), new class_241(-1.0f, 0.0f), new class_241(0.0f, 1.0f)), List.of(new class_241(0.0f, 0.0f), new class_241(0.0f, -1.0f), new class_241(1.0f, 0.0f), new class_241(-1.0f, 0.0f)));
    public static final Supplier<List<List<class_241>>> J = () -> List.of(List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(-1.0f, 1.0f)), List.of(new class_241(-1.0f, -1.0f), new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f)), List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, -1.0f)), List.of(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(1.0f, 1.0f)));
    public static final Supplier<List<List<class_241>>> LINE = () -> List.of(List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(0.0f, 2.0f)), List.of(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(2.0f, 0.0f)));
    public static final Supplier<List<List<class_241>>> Z = () -> List.of(List.of(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(-1.0f, 1.0f), new class_241(0.0f, -1.0f)), List.of(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, 1.0f)));
    public static final Supplier<List<List<class_241>>> SQUARE = () -> List.of(List.of(new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, 1.0f)));
    public static final Supplier<List<List<class_241>>> L = () -> List.of(List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, 1.0f)), List.of(new class_241(-1.0f, 1.0f), new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f)), List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(-1.0f, -1.0f)), List.of(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(1.0f, -1.0f)));
    public static final Supplier<List<List<class_241>>> S = () -> List.of(List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, 0.0f), new class_241(1.0f, 1.0f)), List.of(new class_241(0.0f, -1.0f), new class_241(0.0f, 0.0f), new class_241(1.0f, -1.0f), new class_241(-1.0f, 0.0f)));
    public static final List<Supplier<List<List<class_241>>>> PIECES = List.of(TRIANGLE, J, LINE, Z, SQUARE, L, S);

    public BlocktrisPiece(List<List<class_241>> variants, int x, int y, int color, BlocktrisGame game) {
        this.variants = variants;
        this.x = x;
        this.y = y;
        this.color = color;
        this.grid = game.grid;
        this.game = game;
    }

    public List<class_241> current() {
        return this.variants.get(this.rotation);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isTouching() {
        for (class_241 part : this.current()) {
            if (part.field_1343 + (float)this.x >= (float)this.grid.width() || part.field_1343 + (float)this.x < 0.0f || part.field_1342 + (float)this.y >= (float)this.grid.height() || part.field_1342 + (float)this.y < 0.0f) {
                return true;
            }
            if (this.grid.get((int)part.field_1343 + this.x, (int)part.field_1342 + this.y) == 0) continue;
            return true;
        }
        return false;
    }

    public void rotate() {
        block3: {
            ++this.rotation;
            if (this.rotation >= this.variants.size()) {
                this.rotation = 0;
            }
            if (!this.isTouching()) break block3;
            int oldX = this.x;
            int oldY = this.y;
            int i = 0;
            do {
                this.x = oldX;
                this.y = oldY;
                this.x = (int)((float)this.x + this.altPositions.get((int)i).field_1343);
                this.y = (int)((float)this.y + this.altPositions.get((int)i).field_1342);
                if (!this.isTouching()) break block3;
            } while (++i < this.altPositions.size());
            this.x = oldX;
            this.y = oldY;
            --this.rotation;
            if (this.rotation < 0) {
                this.rotation = this.variants.size() - 1;
            }
        }
    }

    public boolean move(int x, int y) {
        boolean flag = false;
        this.x += x;
        if (this.isTouching()) {
            this.x -= x;
            flag = true;
        }
        this.y += y;
        if (this.isTouching()) {
            this.y -= y;
            flag = true;
        }
        return flag;
    }

    public void hardDrop() {
        while (!this.move(0, 1)) {
        }
    }

    public void place() {
        for (class_241 part : this.current()) {
            this.grid.set(this.x + (int)part.field_1343, this.y + (int)part.field_1342, this.color + 1);
        }
    }

    public void tick() {
        ++this.y;
    }

    public void render(class_332 graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        for (class_241 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (this.x + (int)part.field_1343) * this.grid.tileSize(), posY + (this.y + (int)part.field_1342) * this.grid.tileSize());
        }
    }

    public void renderCentered(class_332 graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        class_241 smallest = null;
        class_241 biggest = null;
        for (int i = 0; i < this.current().size(); ++i) {
            class_241 part = this.current().get(i);
            if (smallest == null) {
                smallest = part;
            }
            if (biggest == null) {
                biggest = part;
            }
            smallest = new class_241(Math.min(smallest.field_1343, part.field_1343), Math.min(smallest.field_1342, part.field_1342));
            biggest = new class_241(Math.max(biggest.field_1343, part.field_1343), Math.max(biggest.field_1342, part.field_1342));
        }
        class_241 addition = smallest.method_35586(biggest.method_35588()).method_35582(0.5f).method_35586(biggest).method_35588();
        for (class_241 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (int)(((float)this.x + part.field_1343 + addition.field_1343) * (float)this.grid.tileSize()), posY + (int)(((float)(this.y + (int)part.field_1342) + addition.field_1342) * (float)this.grid.tileSize()));
        }
    }

    public void setRotation(int direction) {
        this.rotation = direction;
        if (this.rotation >= this.variants.size()) {
            this.rotation = this.variants.size() - 1;
        }
        if (this.rotation < 0) {
            this.rotation = 0;
        }
    }
}

