/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.tejty.gamediscs.games.audio.SoundPlayer;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.controls.Controls;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.ConfettiParticle;
import net.tejty.gamediscs.games.util.ExplosionParticle;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.item.custom.GamingConsoleItem;
import net.tejty.gamediscs.sounds.SoundRegistry;
import net.tejty.gamediscs.util.networking.payload.SetBestScoreC2SPayload;

public class Game {
    public GameStage stage = GameStage.START;
    public Controls controls = new Controls(this);
    public SoundPlayer soundPlayer = new SoundPlayer();
    public static final int WIDTH = 140;
    public static final int HEIGHT = 100;
    public final Random random = new Random();
    public int ticks = 0;
    public int score = 0;
    public int lives = this.maxLives();
    private final List<Particle> particles = new ArrayList<Particle>();

    public int maxLives() {
        return 1;
    }

    public synchronized void prepare() {
        this.score = 0;
        this.lives = this.maxLives();
        this.respawn();
    }

    public synchronized void start() {
        this.stage = GameStage.PLAYING;
        this.ticks = 1;
    }

    public synchronized void die() {
        if (this.getConsole().method_7909() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (class_1657)class_310.method_1551().field_1724) < this.score) {
                ClientPlayNetworking.send((class_8710)new SetBestScoreC2SPayload(gameName, this.score));
                this.soundPlayer.playNewBest();
                this.spawnConfetti();
            } else {
                this.soundPlayer.playGameOver();
            }
        }
        this.stage = GameStage.DIED;
        this.ticks = 1;
    }

    public synchronized void lostLife() {
        --this.lives;
        this.soundPlayer.play(SoundRegistry.EXPLOSION);
        this.respawn();
        if (this.lives <= 0) {
            this.die();
        }
    }

    public synchronized void respawn() {
        this.stage = GameStage.START;
        this.ticks = 1;
        this.particles.clear();
    }

    public synchronized void win() {
        this.soundPlayer.playNewBest();
        this.spawnConfetti();
        if (this.getConsole().method_7909() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (class_1657)class_310.method_1551().field_1724) < this.score) {
                ClientPlayNetworking.send((class_8710)new SetBestScoreC2SPayload(gameName, this.score));
            }
        }
        this.stage = GameStage.WON;
        this.ticks = 1;
    }

    private class_1799 getConsole() {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        class_1799 item = player.method_6047();
        if (item.method_7909() instanceof GamingConsoleItem) {
            return item;
        }
        item = player.method_6079();
        if (item.method_7909() instanceof GamingConsoleItem) {
            return item;
        }
        return new class_1799((class_1935)ItemRegistry.GAMING_CONSOLE);
    }

    public synchronized void tick() {
        if (this.stage == GameStage.PLAYING && this.ticks % this.gameTickDuration() == 0) {
            this.gameTick();
        }
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.tick();
            if (!particle.isDead()) continue;
            this.particles.remove(i);
            --i;
        }
        ++this.ticks;
    }

    public synchronized void gameTick() {
    }

    public synchronized void render(class_332 graphics, int posX, int posY) {
        if (this.getBackground() != null) {
            graphics.method_25291(this.getBackground(), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    public synchronized void renderOverlay(class_332 graphics, int posX, int posY) {
        class_327 font = class_310.method_1551().field_1772;
        if (this.stage != GameStage.PLAYING) {
            if (this.showPressAnyKey()) {
                class_5250 class_52502 = class_2561.method_43471((String)"gui.gamingconsole.press_any_key");
                int n = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.press_any_key").method_30937())) / 2 + 1;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52502, n, posY + 100 - 1 - 9 - 1 + (this.ticks % 40 <= 20 ? 0 : 1), 0x373737, false);
                class_5250 class_52503 = class_2561.method_43471((String)"gui.gamingconsole.press_any_key");
                int n2 = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.press_any_key").method_30937())) / 2;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52503, n2, posY + 100 - 1 - 9 - 2 + (this.ticks % 40 <= 20 ? 0 : 1), 0xFFFFFF, false);
            }
            if (this.showMutiPlayerInfo()) {
                class_5250 class_52504 = class_2561.method_43471((String)"gui.gamingconsole.mutiplayer");
                int n = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.mutiplayer").method_30937())) / 2 + 1;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52504, n, posY + 100 - 1 - 9 - 1 + (this.ticks % 40 <= 20 ? 0 : 1), 0x373737, false);
                class_5250 class_52505 = class_2561.method_43471((String)"gui.gamingconsole.mutiplayer");
                int n3 = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.mutiplayer").method_30937())) / 2;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52505, n3, posY + 100 - 1 - 9 - 2 + (this.ticks % 40 <= 20 ? 0 : 1), 0xFFFFFF, false);
            }
            if (this.showAiReactInfo()) {
                class_5250 class_52506 = class_2561.method_43471((String)"gui.gamingconsole.ai_react");
                int n = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.ai_react").method_30937())) / 2 + 1;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52506, n, posY + 100 - 1 - 9 - 1 + (this.ticks % 40 <= 20 ? 0 : 1), 0x373737, false);
                class_5250 class_52507 = class_2561.method_43471((String)"gui.gamingconsole.ai_react");
                int n4 = posX + (140 - font.method_30880(class_2561.method_43471((String)"gui.gamingconsole.ai_react").method_30937())) / 2;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)class_52507, n4, posY + 100 - 1 - 9 - 2 + (this.ticks % 40 <= 20 ? 0 : 1), 0xFFFFFF, false);
            }
            if ((this.stage == GameStage.DIED || this.stage == GameStage.WON) && this.renderScoreBoard()) {
                graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/score_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                class_5250 component = this.stage == GameStage.DIED ? class_2561.method_43471((String)"gui.gamingconsole.died").method_27695(new class_124[]{class_124.field_1067, class_124.field_1079}) : class_2561.method_43471((String)"gui.gamingconsole.won").method_27695(new class_124[]{class_124.field_1067, class_124.field_1077});
                graphics.method_51439(font, (class_2561)component, posX + (140 - font.method_30880(component.method_30937())) / 2, posY + 29, Objects.requireNonNull(component.method_10866().method_10973()).method_27716(), false);
                graphics.method_51439(font, (class_2561)component, posX + (140 - font.method_30880(component.method_30937())) / 2, posY + 31, component.method_10866().method_10973().method_27716(), false);
                graphics.method_51439(font, (class_2561)component, posX + (140 - font.method_30880(component.method_30937())) / 2 + 1, posY + 30, component.method_10866().method_10973().method_27716(), false);
                graphics.method_51439(font, (class_2561)component, posX + (140 - font.method_30880(component.method_30937())) / 2 - 1, posY + 30, component.method_10866().method_10973().method_27716(), false);
                component = this.stage == GameStage.DIED ? class_2561.method_43471((String)"gui.gamingconsole.died").method_27695(new class_124[]{class_124.field_1067, class_124.field_1061}) : class_2561.method_43471((String)"gui.gamingconsole.won").method_27695(new class_124[]{class_124.field_1067, class_124.field_1060});
                graphics.method_51439(font, (class_2561)component, posX + (140 - font.method_30880(component.method_30937())) / 2, posY + 30, Objects.requireNonNull(component.method_10866().method_10973()).method_27716(), false);
                component = class_2561.method_43471((String)"gui.gamingconsole.score").method_27693(": ").method_27693(String.valueOf(this.score)).method_27692(class_124.field_1054);
                int n = posX + (140 - font.method_30880(component.method_30937())) / 2;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)component, n, posY + 35 + 9, Objects.requireNonNull(component.method_10866().method_10973()).method_27716(), false);
                int bestScore = GamingConsoleItem.getBestScore(this.getConsole(), this.getClass().getName().substring(this.getClass().getPackageName().length() + 1), (class_1657)class_310.method_1551().field_1724);
                component = class_2561.method_43471((String)(this.score >= bestScore ? "gui.gamingconsole.new_best_score" : "gui.gamingconsole.best_score")).method_27693(": ").method_27693(String.valueOf(bestScore)).method_27692(this.score >= bestScore ? class_124.field_1060 : class_124.field_1054);
                int n5 = posX + (140 - font.method_30880(component.method_30937())) / 2;
                Objects.requireNonNull(font);
                graphics.method_51439(font, (class_2561)component, n5, posY + 50 + 9, Objects.requireNonNull(component.method_10866().method_10973()).method_27716(), false);
            }
        } else {
            if (this.showScoreBox() && this.showScore()) {
                if (this.useLongScoreBox()) {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/long_score_box.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                } else {
                    graphics.method_25291(class_2960.method_60655((String)"gamediscs", (String)"textures/gui/score_box.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                }
            }
            if (this.showScore()) {
                graphics.method_51439(font, (class_2561)(this.scoreText() ? class_2561.method_43471((String)"gui.gamingconsole.score").method_27693(": ") : class_2561.method_43473()).method_27693(String.valueOf(this.score)), posX + 2, posY + 2, 0x373737, false);
                graphics.method_51439(font, (class_2561)(this.scoreText() ? class_2561.method_43471((String)"gui.gamingconsole.score").method_27693(": ") : class_2561.method_43473()).method_27693(String.valueOf(this.score)), posX + 1, posY + 1, this.scoreColor(), false);
            }
        }
        for (Particle particle : this.particles) {
            if (!particle.isForOverlay()) continue;
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    public synchronized void renderParticles(class_332 graphics, int posX, int posY) {
        for (Particle particle : this.particles) {
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    public synchronized void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if ((this.stage == GameStage.START || this.stage == GameStage.RETRY) && this.ticks > 8) {
            this.start();
        } else if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
    }

    public Particle addParticle(Particle particle) {
        this.particles.add(particle);
        return particle;
    }

    public void spawnParticleExplosion(Supplier<Renderer> renderer, class_241 pos, int count, int speed, int lifetime, ParticleLevel level) {
        for (int i = 0; i < count; ++i) {
            Particle particle = new Particle(pos, renderer.get(), this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new class_241(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnParticleExplosion(class_241 pos, int count, int speed, int lifetime, ParticleLevel level) {
        this.soundPlayer.play((class_3414)class_3417.field_15152.comp_349(), 1.5f, 0.1f);
        for (int i = 0; i < count; ++i) {
            ExplosionParticle particle = new ExplosionParticle(pos, this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new class_241(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnConfetti() {
        ConfettiParticle particle;
        int i;
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new class_241(0.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new class_241(this.random.nextFloat(1.0f, 10.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new class_241(140.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new class_241(this.random.nextFloat(-10.0f, -1.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
    }

    public synchronized void buttonUp(Button button) {
        this.soundPlayer.playClick(false);
    }

    public int gameTickDuration() {
        return 1;
    }

    public class_2960 getBackground() {
        return null;
    }

    public boolean showScoreBox() {
        return true;
    }

    public boolean useLongScoreBox() {
        return false;
    }

    public boolean showScore() {
        return true;
    }

    public boolean showPressAnyKey() {
        return true;
    }

    public boolean showAiReactInfo() {
        return false;
    }

    public boolean showMutiPlayerInfo() {
        return false;
    }

    public boolean renderScoreBoard() {
        return true;
    }

    public int scoreColor() {
        return 0xFFFFFF;
    }

    public boolean scoreText() {
        return true;
    }

    public class_2561 getName() {
        return class_2561.method_43473();
    }

    public class_2960 getIcon() {
        return null;
    }

    public class_124 getColor() {
        return class_124.field_1054;
    }

    public boolean isEmpty() {
        return this.getClass().equals(Game.class);
    }
}

