/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.trainmap.TrainMapManager;
import com.simibubi.create.compat.trainmap.TrainMapSyncClient;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.RegionMapPanel;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class FTBChunksTrainMap {
    private static int cancelTooltips = 0;
    private static boolean renderingTooltip = false;
    private static boolean requesting;

    public static void tick() {
        if (cancelTooltips > 0) {
            --cancelTooltips;
        }
        LargeMapScreen mapScreen = FTBChunksTrainMap.getAsLargeMapScreen(Minecraft.m_91087_().f_91080_);
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue() || mapScreen == null) {
            if (requesting) {
                TrainMapSyncClient.stopRequesting();
            }
            requesting = false;
            return;
        }
        TrainMapManager.tick((ResourceKey<Level>)mapScreen.currentDimension());
        requesting = true;
        TrainMapSyncClient.requestData();
    }

    public static void cancelTooltips(RenderTooltipEvent.Pre event) {
        if (FTBChunksTrainMap.getAsLargeMapScreen(Minecraft.m_91087_().f_91080_) == null) {
            return;
        }
        if (renderingTooltip || cancelTooltips == 0) {
            return;
        }
        event.setCanceled(true);
    }

    public static void mouseClick(InputEvent.MouseButton.Pre event) {
        LargeMapScreen screen = FTBChunksTrainMap.getAsLargeMapScreen(Minecraft.m_91087_().f_91080_);
        if (screen == null) {
            return;
        }
        if (TrainMapManager.handleToggleWidgetClick(screen.getMouseX(), screen.getMouseY(), 20, 2)) {
            event.setCanceled(true);
        }
    }

    public static void renderGui(ScreenEvent.Render.Post event) {
        LargeMapScreen largeMapScreen = FTBChunksTrainMap.getAsLargeMapScreen(event.getScreen());
        if (largeMapScreen == null) {
            return;
        }
        Object panel = ObfuscationReflectionHelper.getPrivateValue(LargeMapScreen.class, (Object)largeMapScreen, (String)"regionPanel");
        if (!(panel instanceof RegionMapPanel)) {
            return;
        }
        RegionMapPanel regionMapPanel = (RegionMapPanel)panel;
        GuiGraphics graphics = event.getGuiGraphics();
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue()) {
            FTBChunksTrainMap.renderToggleWidgetAndTooltip(event, largeMapScreen, graphics);
            return;
        }
        int blocksPerRegion = 512;
        int minX = Mth.m_14107_((double)regionMapPanel.getScrollX());
        int minY = Mth.m_14107_((double)regionMapPanel.getScrollY());
        float regionTileSize = (float)largeMapScreen.getRegionTileSize() / (float)blocksPerRegion;
        int regionMinX = (Integer)ObfuscationReflectionHelper.getPrivateValue(RegionMapPanel.class, (Object)regionMapPanel, (String)"regionMinX");
        int regionMinZ = (Integer)ObfuscationReflectionHelper.getPrivateValue(RegionMapPanel.class, (Object)regionMapPanel, (String)"regionMinZ");
        float mouseX = event.getMouseX();
        float mouseY = event.getMouseY();
        boolean linearFiltering = (double)largeMapScreen.getRegionTileSize() * Minecraft.m_91087_().m_91268_().m_85449_() < 512.0;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)(-minX), (float)(-minY), 0.0f);
        pose.m_85841_(regionTileSize, regionTileSize, 1.0f);
        pose.m_252880_((float)(-regionMinX * blocksPerRegion), (float)(-regionMinZ * blocksPerRegion), 0.0f);
        mouseX += (float)minX;
        mouseY += (float)minY;
        mouseX /= regionTileSize;
        mouseY /= regionTileSize;
        Rect2i bounds = new Rect2i(Mth.m_14143_((float)((float)minX / regionTileSize + (float)(regionMinX * blocksPerRegion))), Mth.m_14143_((float)((float)minY / regionTileSize + (float)(regionMinZ * blocksPerRegion))), Mth.m_14143_((float)((float)largeMapScreen.width / regionTileSize)), Mth.m_14143_((float)((float)largeMapScreen.height / regionTileSize)));
        List<FormattedText> tooltip = TrainMapManager.renderAndPick(graphics, Mth.m_14143_((float)(mouseX += (float)(regionMinX * blocksPerRegion))), Mth.m_14143_((float)(mouseY += (float)(regionMinZ * blocksPerRegion))), event.getPartialTick(), linearFiltering, bounds);
        pose.m_85849_();
        if (!FTBChunksTrainMap.renderToggleWidgetAndTooltip(event, largeMapScreen, graphics) && tooltip != null) {
            renderingTooltip = true;
            RemovedGuiUtils.drawHoveringText(graphics, tooltip, event.getMouseX(), event.getMouseY(), largeMapScreen.width, largeMapScreen.height, 256, Minecraft.m_91087_().f_91062_);
            renderingTooltip = false;
            cancelTooltips = 5;
        }
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 300.0f);
        for (Widget widget : largeMapScreen.getWidgets()) {
            if (!widget.isEnabled() || widget == panel) continue;
            widget.draw(graphics, largeMapScreen.getTheme(), widget.getPosX(), widget.getPosY(), widget.getWidth(), widget.getHeight());
        }
        pose.m_85849_();
    }

    private static boolean renderToggleWidgetAndTooltip(ScreenEvent.Render.Post event, LargeMapScreen largeMapScreen, GuiGraphics graphics) {
        TrainMapManager.renderToggleWidget(graphics, 20, 2);
        if (!TrainMapManager.isToggleWidgetHovered(event.getMouseX(), event.getMouseY(), 20, 2)) {
            return false;
        }
        renderingTooltip = true;
        RemovedGuiUtils.drawHoveringText(graphics, List.of(CreateLang.translate("train_map.toggle", new Object[0]).component()), event.getMouseX(), event.getMouseY() + 20, largeMapScreen.width, largeMapScreen.height, 256, Minecraft.m_91087_().f_91062_);
        renderingTooltip = false;
        cancelTooltips = 5;
        return true;
    }

    private static LargeMapScreen getAsLargeMapScreen(Screen screen) {
        if (!(screen instanceof ScreenWrapper)) {
            return null;
        }
        ScreenWrapper screenWrapper = (ScreenWrapper)screen;
        BaseScreen wrapped = screenWrapper.getGui();
        if (!(wrapped instanceof LargeMapScreen)) {
            return null;
        }
        LargeMapScreen largeMapScreen = (LargeMapScreen)wrapped;
        return largeMapScreen;
    }
}

