/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.contact;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;

public class ContactMovementBehaviour
implements MovementBehaviour {
    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)RedstoneContactBlock.f_52588_)).m_122436_()).m_82490_((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Contraption contraption;
        BlockState block = context.state;
        Level world = context.world;
        if (world.f_46443_) {
            return;
        }
        if (context.firstMovement) {
            return;
        }
        this.deactivateLastVisitedContact(context);
        BlockState visitedState = world.m_8055_(pos);
        if (!AllBlocks.REDSTONE_CONTACT.has(visitedState) && !AllBlocks.ELEVATOR_CONTACT.has(visitedState)) {
            return;
        }
        Vec3 contact = Vec3.m_82528_((Vec3i)((Direction)block.m_61143_((Property)RedstoneContactBlock.f_52588_)).m_122436_());
        contact = (Vec3)context.rotation.apply(contact);
        Direction direction = Direction.m_122366_((double)contact.f_82479_, (double)contact.f_82480_, (double)contact.f_82481_);
        if (visitedState.m_61143_((Property)RedstoneContactBlock.f_52588_) != direction.m_122424_()) {
            return;
        }
        if (AllBlocks.REDSTONE_CONTACT.has(visitedState)) {
            world.m_46597_(pos, (BlockState)visitedState.m_61124_((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        }
        if (AllBlocks.ELEVATOR_CONTACT.has(visitedState) && (contraption = context.contraption) instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            ec.broadcastFloorData(world, pos);
        }
        context.data.m_128365_("lastContact", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.deactivateLastVisitedContact(context);
    }

    @Override
    public void cancelStall(MovementContext context) {
        MovementBehaviour.super.cancelStall(context);
        this.deactivateLastVisitedContact(context);
    }

    public void deactivateLastVisitedContact(MovementContext context) {
        if (!context.data.m_128441_("lastContact")) {
            return;
        }
        BlockPos last = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_("lastContact"));
        context.data.m_128473_("lastContact");
        BlockState blockState = context.world.m_8055_(last);
        if (AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            context.world.m_186464_(last, (Block)AllBlocks.REDSTONE_CONTACT.get(), 1, TickPriority.NORMAL);
        }
    }
}

