/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SignalBlock
extends Block
implements IBE<SignalBlockEntity>,
IWrenchable {
    public static final EnumProperty<SignalType> TYPE = EnumProperty.m_61587_((String)"type", SignalType.class);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public SignalBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)SignalType.ENTRY_SIGNAL))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Class<SignalBlockEntity> getBlockEntityClass() {
        return SignalBlockEntity.class;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{TYPE, POWERED}));
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_276867_(pContext.m_8083_())));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean powered = (Boolean)pState.m_61143_((Property)POWERED);
        Optional ste = this.getBlockEntityOptional((BlockGetter)pLevel, pPos);
        boolean neighborPowered = false;
        if (ste.isEmpty() || !((SignalBlockEntity)ste.get()).computerBehaviour.hasAttachedComputer()) {
            powered = pLevel.m_276867_(pPos);
        }
        if (powered == neighborPowered) {
            return;
        }
        if (powered) {
            pLevel.m_186460_(pPos, (Block)this, 4);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        Optional ste = this.getBlockEntityOptional((BlockGetter)pLevel, pPos);
        if ((ste.isEmpty() || !((SignalBlockEntity)ste.get()).computerBehaviour.hasAttachedComputer()) && ((Boolean)pState.m_61143_((Property)POWERED)).booleanValue() && !pLevel.m_276867_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove(state, worldIn, pos, newState);
    }

    @Override
    public BlockEntityType<? extends SignalBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TRACK_SIGNAL.get();
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, ste -> {
            Player player = context.m_43723_();
            if (ste.computerBehaviour.hasAttachedComputer()) {
                if (player != null) {
                    player.m_5661_((Component)CreateLang.translateDirect("track_signal.mode_controlled_by_computer", new Object[0]), true);
                }
                return;
            }
            SignalBoundary signal = ste.getSignal();
            if (signal != null) {
                signal.cycleSignalType(pos);
                if (player != null) {
                    player.m_5661_((Component)CreateLang.translateDirect("track_signal.mode_change." + signal.getTypeFor(pos).m_7912_(), new Object[0]), true);
                }
            } else if (player != null) {
                player.m_5661_((Component)CreateLang.translateDirect("track_signal.cannot_change_mode", new Object[0]), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level blockAccess, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)blockAccess, pPos).filter(SignalBlockEntity::isPowered).map($ -> 15).orElse(0);
    }

    public static enum SignalType implements StringRepresentable
    {
        ENTRY_SIGNAL,
        CROSS_SIGNAL;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

