/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockEntityRenderHelper {
    public static void renderBlockEntities(List<BlockEntity> blockEntities, BitSet shouldRenderBEs, BitSet erroredBEsOut, @Nullable VirtualRenderWorld renderLevel, Level realLevel, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        int i = shouldRenderBEs.nextSetBit(0);
        while (i >= 0 && i < blockEntities.size()) {
            BlockEntity blockEntity = blockEntities.get(i);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)realLevel) || !VisualizationHelper.skipVanillaRender((BlockEntity)blockEntity)) {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
                if (renderer == null) {
                    erroredBEsOut.set(i);
                } else {
                    BlockPos pos = blockEntity.m_58899_();
                    ms.m_85836_();
                    TransformStack.of((PoseStack)ms).translate((Vec3i)pos);
                    try {
                        int light;
                        int realLevelLight = LevelRenderer.m_109541_((BlockAndTintGetter)realLevel, (BlockPos)BlockEntityRenderHelper.getLightPos(lightTransform, pos));
                        if (renderLevel != null) {
                            renderLevel.setExternalLight(realLevelLight);
                            light = LevelRenderer.m_109541_((BlockAndTintGetter)renderLevel, (BlockPos)pos);
                        } else {
                            light = realLevelLight;
                        }
                        renderer.m_6922_(blockEntity, pt, ms, buffer, light, OverlayTexture.f_118083_);
                    }
                    catch (Exception e) {
                        erroredBEsOut.set(i);
                        String message = "BlockEntity " + String.valueOf(CatnipServices.REGISTRIES.getKeyOrThrow(blockEntity.m_58903_())) + " could not be rendered virtually.";
                        if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                            Create.LOGGER.error(message, (Throwable)e);
                        }
                        Create.LOGGER.error(message);
                    }
                    ms.m_85849_();
                }
            }
            i = shouldRenderBEs.nextSetBit(i + 1);
        }
        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.m_123341_() + 0.5f, (float)contraptionPos.m_123342_() + 0.5f, (float)contraptionPos.m_123343_() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.m_274561_((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }
}

