/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.nbt.NBTProcessors;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZapperItem
extends Item
implements CustomArmPoseItem {
    public ZapperItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            MutableComponent usedBlock = ((BlockState)stack.get(AllDataComponents.SHAPER_BLOCK_USED)).getBlock().getName();
            tooltip.add((Component)CreateLang.translateDirect("terrainzapper.usingBlock", usedBlock.withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean differentBlock = false;
        if (oldStack.has(AllDataComponents.SHAPER_BLOCK_USED) && newStack.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            differentBlock = oldStack.get(AllDataComponents.SHAPER_BLOCK_USED) != newStack.get(AllDataComponents.SHAPER_BLOCK_USED);
        }
        return slotChanged || !this.isZapper(newStack) || differentBlock;
    }

    public boolean isZapper(ItemStack newStack) {
        return newStack.getItem() instanceof ZapperItem;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            if (context.getLevel().isClientSide) {
                CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.openHandgunGUI(context.getItemInHand(), context.getHand()));
                context.getPlayer().getCooldowns().addCooldown(context.getItemInHand().getItem(), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        boolean mainHand;
        ItemStack item = player.getItemInHand(hand);
        boolean bl = mainHand = hand == InteractionHand.MAIN_HAND;
        if (player.isShiftKeyDown()) {
            if (world.isClientSide) {
                CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.openHandgunGUI(item, hand));
                player.getCooldowns().addCooldown(item.getItem(), 10);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (ShootableGadgetItemMethods.shouldSwap(player, item, hand, this::isZapper)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        Component msg = this.validateUsage(item);
        if (msg != null) {
            AllSoundEvents.DENY.play(world, player, (Vec3i)player.blockPosition());
            player.displayClientMessage((Component)msg.plainCopy().withStyle(ChatFormatting.RED), true);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        BlockState stateToUse = Blocks.AIR.defaultBlockState();
        if (item.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            stateToUse = (BlockState)item.get(AllDataComponents.SHAPER_BLOCK_USED);
        }
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        CompoundTag data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(stateToUse) && item.has(AllDataComponents.SHAPER_BLOCK_DATA)) {
            data = (CompoundTag)item.get(AllDataComponents.SHAPER_BLOCK_DATA);
        }
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 range = player.getLookAngle().scale((double)this.getZappingRange(item));
        BlockHitResult raytrace = world.clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = raytrace.getBlockPos();
        BlockState stateReplaced = world.getBlockState(pos);
        if (pos == null || stateReplaced.getBlock() == Blocks.AIR) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, mainHand, new Vec3((double)0.35f, (double)-0.1f, 1.0));
        if (world.isClientSide) {
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (this.activate(world, player, item, stateToUse, raytrace, data)) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            ShootableGadgetItemMethods.sendPackets(player, b -> new ZapperBeamPacket(barrelPos, hand, (boolean)b, raytrace.getLocation()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
    }

    public Component validateUsage(ItemStack item) {
        if (!this.canActivateWithoutSelectedBlock(item) && !item.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            return CreateLang.translateDirect("terrainzapper.leftClickToSet", new Object[0]);
        }
        return null;
    }

    protected abstract boolean activate(Level var1, Player var2, ItemStack var3, BlockState var4, BlockHitResult var5, CompoundTag var6);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void openHandgunGUI(ItemStack var1, InteractionHand var2);

    protected abstract int getCooldownDelay(ItemStack var1);

    protected abstract int getZappingRange(ItemStack var1);

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return false;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public static void setBlockEntityData(Level world, BlockPos pos, BlockState state, CompoundTag data, Player player) {
        BlockEntity blockEntity;
        if (data != null && AllTags.AllBlockTags.SAFE_NBT.matches(state) && (blockEntity = world.getBlockEntity(pos)) != null) {
            if ((data = NBTProcessors.process((BlockState)state, (BlockEntity)blockEntity, (CompoundTag)data, (!player.isCreative() ? 1 : 0) != 0)) == null) {
                return;
            }
            data.putInt("x", pos.getX());
            data.putInt("y", pos.getY());
            data.putInt("z", pos.getZ());
            blockEntity.loadWithComponents(data, (HolderLookup.Provider)world.registryAccess());
        }
    }
}

