/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation;

import com.simibubi.create.AllBlockEntityTypes;
import java.util.function.UnaryOperator;
import net.createmod.catnip.nbt.NBTProcessors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CreateNBTProcessors {
    public static void register() {
        NBTProcessors.addProcessor((BlockEntityType)BlockEntityType.LECTERN, data -> {
            if (!data.contains("Book", 10)) {
                return data;
            }
            CompoundTag book = data.getCompound("Book");
            ResourceLocation writableBookResource = BuiltInRegistries.ITEM.getKey((Object)Items.WRITABLE_BOOK);
            if (writableBookResource != BuiltInRegistries.ITEM.getDefaultKey() && book.getString("id").equals(writableBookResource.toString())) {
                return data;
            }
            if (!book.contains("tag", 10)) {
                return data;
            }
            CompoundTag tag = book.getCompound("tag");
            if (!tag.contains("pages", 9)) {
                return data;
            }
            ListTag pages = tag.getList("pages", 8);
            for (Tag inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent((String)inbt.getAsString())) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.CLIPBOARD.get()), CreateNBTProcessors::clipboardProcessor);
        NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.CREATIVE_CRATE.get()), (UnaryOperator)NBTProcessors.itemProcessor((String)"Filter"));
    }

    public static CompoundTag clipboardProcessor(CompoundTag data) {
        if (!data.contains("Item", 10)) {
            return data;
        }
        CompoundTag item = data.getCompound("Item");
        if (!item.contains("components", 10)) {
            return data;
        }
        CompoundTag itemComponents = item.getCompound("components");
        if (!itemComponents.contains("create:clipboard_pages", 9)) {
            return data;
        }
        ListTag pages = itemComponents.getList("create:clipboard_pages", 9);
        for (Tag page : pages) {
            if (!(page instanceof ListTag)) {
                return data;
            }
            ListTag entries = (ListTag)page;
            for (int i = 0; i < entries.size(); ++i) {
                CompoundTag entry = entries.getCompound(i);
                if (!NBTProcessors.textComponentHasClickEvent((String)entry.getCompound("text").getAsString())) continue;
                return null;
            }
        }
        return data;
    }
}

