/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredientOld;
import com.simibubi.create.foundation.item.ItemSlots;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

public class CreateCodecs {
    public static final Codec<Integer> INT_STR = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException ignored) {
            return DataResult.error(() -> "Not an integer: " + string);
        }
    }, String::valueOf);
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER = Codec.lazyInitialized(() -> ItemSlots.CODEC.xmap(slots -> slots.toHandler(ItemStackHandler::new), ItemSlots::fromHandler));
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(0.0, Double.MAX_VALUE, i -> "Value must be non-negative: " + i);
    public static final Codec<Double> POSITIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(1.0, Double.MAX_VALUE, i -> "Value must be positive: " + i);
    public static Codec<SizedFluidIngredient> FLAT_SIZED_FLUID_INGREDIENT_WITH_TYPE = RecordCodecBuilder.create(instance -> instance.group((App)NeoForgeRegistries.FLUID_INGREDIENT_TYPES.byNameCodec().fieldOf("type").forGetter(i -> i.ingredient().getType()), (App)FluidIngredient.MAP_CODEC_NONEMPTY.forGetter(SizedFluidIngredient::ingredient), (App)NeoForgeExtraCodecs.optionalFieldAlwaysWrite((Codec)ExtraCodecs.POSITIVE_INT, (String)"amount", (Object)1000).forGetter(SizedFluidIngredient::amount)).apply((Applicative)instance, (type, ingredient, amount) -> new SizedFluidIngredient(ingredient, amount.intValue())));
    @Deprecated(since="6.0.7", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.1+ Port")
    public static Codec<SizedFluidIngredient> SIZED_FLUID_INGREDIENT = Codec.withAlternative(FLAT_SIZED_FLUID_INGREDIENT_WITH_TYPE, FluidIngredientOld.CODEC);

    public static Codec<Integer> boundedIntStr(int min) {
        return INT_STR.validate(i -> i >= min ? DataResult.success((Object)i) : DataResult.error(() -> "Value under minimum of " + min));
    }

    private static Codec<Double> doubleRangeWithMessage(double min, double max, Function<Double, String> errorMessage) {
        return Codec.DOUBLE.validate(i -> i.compareTo(min) >= 0 && i.compareTo(max) <= 0 ? DataResult.success((Object)i) : DataResult.error(() -> (String)errorMessage.apply((Double)i)));
    }
}

