/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc;

import de.ayont.lpc.commands.LPCCommand;
import de.ayont.lpc.listener.AsyncChatListener;
import de.ayont.lpc.listener.SpigotChatListener;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LPC
extends JavaPlugin {
    private boolean isPaper;
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().character('\u00a7').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public static LegacyComponentSerializer getLegacySerializer() {
        return legacySerializer;
    }

    public void onEnable() {
        this.isPaper = this.checkIfPaper();
        this.registerCommand();
        this.saveDefaultConfig();
        this.registerListeners();
    }

    public void registerCommand() {
        String commandName = "lpc";
        LPCCommand lpcCommand = new LPCCommand(this);
        this.getCommand(commandName).setExecutor((CommandExecutor)lpcCommand);
        this.getCommand(commandName).setTabCompleter((TabCompleter)lpcCommand);
    }

    private boolean checkIfPaper() {
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            this.getLogger().info("Paper API has been detected and will be used.");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().info("Spigot API has been detected and will be used.");
            return false;
        }
    }

    private void registerListeners() {
        if (this.isPaper) {
            this.getServer().getPluginManager().registerEvents((Listener)new AsyncChatListener(this), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new SpigotChatListener(this), (Plugin)this);
        }
    }
}

