/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc.commands;

import de.ayont.lpc.LPC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class LPCCommand
implements CommandExecutor,
TabCompleter {
    private final LPC plugin;

    public LPCCommand(LPC plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1 && "reload".equals(args[0])) {
            this.plugin.reloadConfig();
            String rawReloadMessage = this.plugin.getConfig().getString("reload-message", "<green>Reloaded LPC Configuration!</green>");
            Object message = MiniMessage.miniMessage().deserialize(rawReloadMessage);
            if (this.plugin.getServer().getName().toLowerCase().contains("paper")) {
                sender.sendMessage(message);
            } else {
                sender.sendMessage(LPC.getLegacySerializer().serialize((Component)message));
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("reload");
        }
        return new ArrayList<String>();
    }
}

