/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc.listener;

import de.ayont.lpc.LPC;
import de.ayont.lpc.renderer.LPCChatRenderer;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class AsyncChatListener
implements Listener {
    private final LPC plugin;
    private final LPCChatRenderer lpcChatRenderer;

    public AsyncChatListener(LPC plugin) {
        this.plugin = plugin;
        this.lpcChatRenderer = new LPCChatRenderer(plugin);
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        Component displayName;
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("use-item-placeholder", false) || !player.hasPermission("lpc.itemplaceholder")) {
            event.renderer((ChatRenderer)this.lpcChatRenderer);
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Component component = displayName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().displayName() : Component.text(item.getType().toString().toLowerCase().replace("_", " "));
        if (item.getType().equals((Object)Material.AIR) || displayName == null) {
            event.renderer((ChatRenderer)this.lpcChatRenderer);
            return;
        }
        event.renderer((source, sourceDisplayName, message, viewer) -> this.lpcChatRenderer.render(source, sourceDisplayName, message, viewer).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(Pattern.compile("\\[item]", 2)).replacement((ComponentLike)((Object)displayName.hoverEvent((HoverEventSource)item))).build()));
    }
}

