/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc.listener;

import de.ayont.lpc.LPC;
import de.ayont.lpc.renderer.SpigotChatRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpigotChatListener
implements Listener {
    private final LPC plugin;
    private final SpigotChatRenderer chatRenderer;
    private final Map<String, String> legacyToMiniMessageColors;

    public SpigotChatListener(LPC plugin) {
        this.plugin = plugin;
        this.chatRenderer = new SpigotChatRenderer(plugin);
        this.legacyToMiniMessageColors = new HashMap<String, String>();
        this.initColorMappings();
    }

    private void initColorMappings() {
        this.legacyToMiniMessageColors.put("&0", "<black>");
        this.legacyToMiniMessageColors.put("&1", "<dark_blue>");
        this.legacyToMiniMessageColors.put("&2", "<dark_green>");
        this.legacyToMiniMessageColors.put("&3", "<dark_aqua>");
        this.legacyToMiniMessageColors.put("&4", "<dark_red>");
        this.legacyToMiniMessageColors.put("&5", "<dark_purple>");
        this.legacyToMiniMessageColors.put("&6", "<gold>");
        this.legacyToMiniMessageColors.put("&7", "<gray>");
        this.legacyToMiniMessageColors.put("&8", "<dark_gray>");
        this.legacyToMiniMessageColors.put("&9", "<blue>");
        this.legacyToMiniMessageColors.put("&a", "<green>");
        this.legacyToMiniMessageColors.put("&b", "<aqua>");
        this.legacyToMiniMessageColors.put("&c", "<red>");
        this.legacyToMiniMessageColors.put("&d", "<light_purple>");
        this.legacyToMiniMessageColors.put("&e", "<yellow>");
        this.legacyToMiniMessageColors.put("&f", "<white>");
        this.legacyToMiniMessageColors.put("&l", "<bold>");
        this.legacyToMiniMessageColors.put("&o", "<italic>");
        this.legacyToMiniMessageColors.put("&n", "<underlined>");
        this.legacyToMiniMessageColors.put("&m", "<strikethrough>");
        this.legacyToMiniMessageColors.put("&k", "<obfuscated>");
        this.legacyToMiniMessageColors.put("&r", "<reset>");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChat(AsyncPlayerChatEvent event) {
        ItemStack item;
        String message = event.getMessage();
        if (event.getPlayer().hasPermission("lpc.chatcolor")) {
            message = message.replaceAll("\u00a7", "&");
            for (Map.Entry<String, String> entry : this.legacyToMiniMessageColors.entrySet()) {
                message = message.replace(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : this.legacyToMiniMessageColors.entrySet()) {
                message = message.replace(entry.getValue(), entry.getKey());
            }
        }
        if (this.plugin.getConfig().getBoolean("use-item-placeholder", false) && event.getPlayer().hasPermission("lpc.itemplaceholder") && !(item = event.getPlayer().getInventory().getItemInMainHand()).getType().equals((Object)Material.AIR)) {
            Object itemName = item.getType().toString().toLowerCase().replace("_", " ");
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                StringBuilder hoverText;
                block15: {
                    hoverText = new StringBuilder();
                    if (meta.hasDisplayName()) {
                        try {
                            Component displayName = meta.displayName();
                            if (displayName != null) {
                                itemName = (String)MiniMessage.miniMessage().serialize(displayName);
                            }
                        }
                        catch (NoSuchMethodError e) {
                            String displayName = meta.getDisplayName();
                            itemName = (String)MiniMessage.miniMessage().serialize(LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().character('\u00a7').build().deserialize(displayName));
                        }
                    }
                    if (meta.hasLore()) {
                        try {
                            List lore = meta.lore();
                            if (lore == null) break block15;
                            for (Component line : lore) {
                                hoverText.append("\n").append((String)MiniMessage.miniMessage().serialize(line));
                            }
                        }
                        catch (NoSuchMethodError e) {
                            List lore = meta.getLore();
                            if (lore == null) break block15;
                            for (String line : lore) {
                                hoverText.append("\n").append((String)MiniMessage.miniMessage().serialize(LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().character('\u00a7').build().deserialize(line)));
                            }
                        }
                    }
                }
                itemName = "<hover:show_text:'" + (String)itemName + hoverText.toString() + "'>" + (String)itemName + "</hover>";
            }
            message = message.replaceFirst("(?i)\\[item]", (String)itemName);
        }
        event.setFormat(LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build().serialize(this.chatRenderer.render(event.getPlayer(), message)));
    }
}

