/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc.renderer;

import de.ayont.lpc.LPC;
import io.papermc.paper.chat.ChatRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.track.Track;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class LPCChatRenderer
implements ChatRenderer {
    private final LuckPerms luckPerms;
    private final LPC plugin;
    private final MiniMessage miniMessage;
    private final boolean hasPapi;
    private final Map<String, String> legacyToMiniMessageColors = new HashMap<String, String>(){
        {
            this.put("&0", "<black>");
            this.put("&1", "<dark_blue>");
            this.put("&2", "<dark_green>");
            this.put("&3", "<dark_aqua>");
            this.put("&4", "<dark_red>");
            this.put("&5", "<dark_purple>");
            this.put("&6", "<gold>");
            this.put("&7", "<gray>");
            this.put("&8", "<dark_gray>");
            this.put("&9", "<blue>");
            this.put("&a", "<green>");
            this.put("&b", "<aqua>");
            this.put("&c", "<red>");
            this.put("&d", "<light_purple>");
            this.put("&e", "<yellow>");
            this.put("&f", "<white>");
        }
    };

    public LPCChatRenderer(LPC plugin) {
        this.luckPerms = LuckPermsProvider.get();
        this.plugin = plugin;
        this.miniMessage = MiniMessage.builder().build();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        this.hasPapi = pluginManager.getPlugin("PlaceholderAPI") != null;
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message, @NotNull Audience viewer) {
        ConfigurationSection trackFormatsSection;
        CachedMetaData metaData = this.luckPerms.getPlayerAdapter(Player.class).getMetaData((Object)source);
        String group = Objects.requireNonNull(metaData.getPrimaryGroup(), "Primary group cannot be null");
        boolean hasPermission = source.hasPermission("lpc.chatcolor");
        String plainMessage = PlainTextComponentSerializer.plainText().serialize(message);
        if (hasPermission) {
            for (Map.Entry<String, String> entry : this.legacyToMiniMessageColors.entrySet()) {
                plainMessage = plainMessage.replace(entry.getKey(), entry.getValue());
            }
        }
        String formatKey = "group-formats." + group;
        String format = this.plugin.getConfig().getString(formatKey);
        if (format == null && (trackFormatsSection = this.plugin.getConfig().getConfigurationSection("track-formats")) != null) {
            for (String trackName : trackFormatsSection.getKeys(false)) {
                Track track = this.luckPerms.getTrackManager().getTrack(trackName);
                if (track == null || !track.containsGroup(group)) continue;
                formatKey = "track-formats." + trackName;
                format = this.plugin.getConfig().getString(formatKey);
                break;
            }
        }
        if (format == null) {
            format = this.plugin.getConfig().getString("chat-format");
        }
        format = format.replace("{prefix}", metaData.getPrefix() != null ? metaData.getPrefix() : "").replace("{suffix}", metaData.getSuffix() != null ? metaData.getSuffix() : "").replace("{prefixes}", String.join((CharSequence)" ", metaData.getPrefixes().values())).replace("{suffixes}", String.join((CharSequence)" ", metaData.getSuffixes().values())).replace("{world}", source.getWorld().getName()).replace("{name}", source.getName()).replace("{displayname}", PlainTextComponentSerializer.plainText().serialize(source.displayName())).replace("{username-color}", metaData.getMetaValue("username-color") != null ? (CharSequence)Objects.requireNonNull(metaData.getMetaValue("username-color")) : "").replace("{message-color}", metaData.getMetaValue("message-color") != null ? (CharSequence)Objects.requireNonNull(metaData.getMetaValue("message-color")) : "");
        if (!hasPermission) {
            for (Map.Entry<String, String> entry : this.legacyToMiniMessageColors.entrySet()) {
                plainMessage = plainMessage.replace(entry.getValue(), entry.getKey());
            }
        }
        format = format.replace("{message}", plainMessage);
        if (this.hasPapi) {
            format = PlaceholderAPI.setPlaceholders((Player)source, (String)format);
        }
        return this.miniMessage.deserialize(format);
    }
}

