/*
 * Decompiled with CFR 0.152.
 */
package de.ayont.lpc.renderer;

import de.ayont.lpc.LPC;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.track.Track;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class SpigotChatRenderer {
    private final LuckPerms luckPerms = LuckPermsProvider.get();
    private final LPC plugin;
    private final MiniMessage miniMessage;
    private final boolean hasPapi;

    public SpigotChatRenderer(LPC plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.builder().build();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        this.hasPapi = pluginManager.getPlugin("PlaceholderAPI") != null;
    }

    @NotNull
    public Component render(Player source, String message) {
        ConfigurationSection trackFormatsSection;
        CachedMetaData metaData = this.luckPerms.getPlayerAdapter(Player.class).getMetaData((Object)source);
        String group = Objects.requireNonNull(metaData.getPrimaryGroup(), "Primary group cannot be null");
        String plainMessage = source.hasPermission("lpc.chatcolor") ? message : this.stripMiniMessageTags(message);
        String formatKey = "group-formats." + group;
        String format = this.plugin.getConfig().getString(formatKey);
        if (format == null && (trackFormatsSection = this.plugin.getConfig().getConfigurationSection("track-formats")) != null) {
            for (String trackName : trackFormatsSection.getKeys(false)) {
                Track track = this.luckPerms.getTrackManager().getTrack(trackName);
                if (track == null || !track.containsGroup(group)) continue;
                formatKey = "track-formats." + trackName;
                format = this.plugin.getConfig().getString(formatKey);
                break;
            }
        }
        if (format == null) {
            format = this.plugin.getConfig().getString("chat-format");
        }
        format = format.replace("{prefix}", metaData.getPrefix() != null ? metaData.getPrefix() : "").replace("{suffix}", metaData.getSuffix() != null ? metaData.getSuffix() : "").replace("{prefixes}", String.join((CharSequence)" ", metaData.getPrefixes().values())).replace("{suffixes}", String.join((CharSequence)" ", metaData.getSuffixes().values())).replace("{world}", source.getWorld().getName()).replace("{name}", source.getName()).replace("{displayname}", source.getDisplayName()).replace("{username-color}", metaData.getMetaValue("username-color") != null ? (CharSequence)Objects.requireNonNull(metaData.getMetaValue("username-color")) : "").replace("{message-color}", metaData.getMetaValue("message-color") != null ? (CharSequence)Objects.requireNonNull(metaData.getMetaValue("message-color")) : "").replace("{message}", plainMessage);
        if (this.hasPapi) {
            format = PlaceholderAPI.setPlaceholders((Player)source, (String)format);
        }
        return this.miniMessage.deserialize(format);
    }

    private String stripMiniMessageTags(String message) {
        return message.replaceAll("<[^>]*>", "");
    }
}

