/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.PortstoneBlockEntity;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class PortstoneBlock
extends WaystoneBlockBase {
    public static final MapCodec<PortstoneBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.fieldOf("color").forGetter(PortstoneBlock::getColor), (App)PortstoneBlock.method_54096()).apply((Applicative)instance, PortstoneBlock::new));
    private static final class_265[] LOWER_SHAPES = new class_265[]{class_259.method_17786((class_265)PortstoneBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (class_265[])new class_265[]{PortstoneBlock.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.method_9541((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.method_9541((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)7.0), PortstoneBlock.method_9541((double)4.0, (double)9.0, (double)7.0, (double)12.0, (double)16.0, (double)10.0), PortstoneBlock.method_9541((double)4.0, (double)9.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0)}).method_1097(), class_259.method_17786((class_265)PortstoneBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (class_265[])new class_265[]{PortstoneBlock.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.method_9541((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.method_9541((double)9.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.method_9541((double)6.0, (double)9.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0), PortstoneBlock.method_9541((double)4.0, (double)9.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0)}).method_1097(), class_259.method_17786((class_265)PortstoneBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (class_265[])new class_265[]{PortstoneBlock.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.method_9541((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.method_9541((double)3.0, (double)9.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.method_9541((double)4.0, (double)9.0, (double)6.0, (double)12.0, (double)16.0, (double)9.0), PortstoneBlock.method_9541((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)6.0)}).method_1097(), class_259.method_17786((class_265)PortstoneBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (class_265[])new class_265[]{PortstoneBlock.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.method_9541((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.method_9541((double)3.0, (double)9.0, (double)3.0, (double)7.0, (double)16.0, (double)13.0), PortstoneBlock.method_9541((double)7.0, (double)9.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), PortstoneBlock.method_9541((double)10.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)}).method_1097()};
    private static final class_265[] UPPER_SHAPES = new class_265[]{class_259.method_1084((class_265)PortstoneBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0), (class_265)PortstoneBlock.method_9541((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).method_1097(), class_259.method_1084((class_265)PortstoneBlock.method_9541((double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (class_265)PortstoneBlock.method_9541((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).method_1097(), class_259.method_1084((class_265)PortstoneBlock.method_9541((double)3.0, (double)0.0, (double)9.0, (double)13.0, (double)7.0, (double)13.0), (class_265)PortstoneBlock.method_9541((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).method_1097(), class_259.method_1084((class_265)PortstoneBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)7.0, (double)7.0, (double)13.0), (class_265)PortstoneBlock.method_9541((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).method_1097()};
    private final class_1767 color;

    public PortstoneBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1767 getColor() {
        return this.color;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654((class_2769)HALF) == class_2756.field_12609 ? UPPER_SHAPES[direction.method_10161()] : LOWER_SHAPES[direction.method_10161()];
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PortstoneBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 blockHitResult) {
        if (!world.method_8608()) {
            class_2960 targetWaystoneType = this.getTargetWaystoneType();
            final ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getTargetsForWaystoneType(player, targetWaystoneType));
            PlayerWaystoneManager.ensureSortingIndex(player, waystones);
            Balm.getNetworking().openMenu(player, (class_3908)new BalmMenuProvider<List<Waystone>>(){

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)("container.waystones." + PortstoneBlock.this.color.method_15434() + "_portstone"));
                }

                public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
                    return new WaystoneSelectionMenu((class_3917<WaystoneSelectionMenu>)((class_3917)ModMenus.portstoneSelection.get()), null, windowId, waystones, Set.of(TeleportFlags.PORTSTONE));
                }

                public List<Waystone> getScreenOpeningData(class_3222 serverPlayer) {
                    return waystones;
                }

                public class_9139<class_9129, List<Waystone>> getScreenStreamCodec() {
                    return WaystoneImpl.LIST_STREAM_CODEC;
                }
            });
        }
        return class_1269.field_5812;
    }

    private class_2960 getTargetWaystoneType() {
        return WaystoneTypes.getSharestone(this.color).orElse(WaystoneTypes.WAYSTONE);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HALF});
    }

    public boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        return false;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }
}

