/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import java.util.Objects;
import net.blay09.mods.waystones.api.WaystoneStyle;
import net.blay09.mods.waystones.api.WaystoneStyles;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class WaystoneRenderer
implements class_827<WaystoneBlockEntity, WaystoneRenderState> {
    private static final class_4730 MATERIAL = new class_4730(class_1059.field_5275, class_2960.method_60656((String)"waystone_overlays/waystone_active"));
    private final class_11701 materials;
    private final SharestoneModel model;

    public WaystoneRenderer(class_5614.class_5615 context) {
        this.materials = context.comp_4541();
        this.model = new SharestoneModel(context.method_32140(ModRenderers.waystoneModel));
    }

    public WaystoneRenderState createRenderState() {
        return new WaystoneRenderState();
    }

    public void extractRenderState(WaystoneBlockEntity blockEntity, WaystoneRenderState renderState, float delta, class_243 vec, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, delta, vec, crumblingOverlay);
        if (renderState.field_62674.method_11654((class_2769)SharestoneBlock.HALF) != class_2756.field_12607) {
            renderState.skip = true;
            return;
        }
        renderState.facing = (class_2350)renderState.field_62674.method_11654((class_2769)PortstoneBlock.FACING);
        renderState.glow = !WaystonesConfig.getActive().client.disableTextGlow;
        WaystoneStyle style = WaystoneStyles.getStyle(renderState.field_62674.method_26204());
        renderState.runeColor = style != null ? style.getRuneColor() : -1;
        class_746 player = class_310.method_1551().field_1724;
        renderState.showRunes = PlayerWaystoneManager.isWaystoneActivated((class_1657)Objects.requireNonNull(player), blockEntity.getWaystone());
    }

    public void submit(WaystoneRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (renderState.skip) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderState.facing.method_10144()));
        poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(180.0f));
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        if (renderState.showRunes) {
            poseStack.method_22905(1.05f, 1.05f, 1.05f);
            class_1058 sprite = this.materials.method_73030(MATERIAL);
            submitNodeCollector.method_73490((class_3879)this.model, (Object)class_3902.field_17274, poseStack, MATERIAL.method_24146(class_1921::method_23576), renderState.glow ? 0xF000F0 : renderState.field_62676, class_4608.field_21444, renderState.runeColor, sprite, 0, renderState.field_62677);
        }
        poseStack.method_22909();
    }

    public static class WaystoneRenderState
    extends class_11954 {
        public boolean skip;
        public class_2350 facing = class_2350.field_11043;
        public boolean glow;
        public boolean showRunes;
        public int runeColor;
    }
}

