/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.api;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface WaystoneTeleportContext {
    public Entity getEntity();

    public Waystone getTargetWaystone();

    public List<Mob> getLeashedEntities();

    public List<Entity> getAdditionalEntities();

    public WaystoneTeleportContext addAdditionalEntity(Entity var1);

    public Optional<Waystone> getFromWaystone();

    public WaystoneTeleportContext setFromWaystone(@Nullable Waystone var1);

    public ItemStack getWarpItem();

    public WaystoneTeleportContext setWarpItem(ItemStack var1);

    public InteractionHand getWarpHand();

    public WaystoneTeleportContext setWarpHand(InteractionHand var1);

    public boolean isDimensionalTeleport();

    public WarpRequirement getRequirements();

    public WaystoneTeleportContext setRequirements(WarpRequirement var1);

    public boolean playsSound();

    public WaystoneTeleportContext setPlaysSound(boolean var1);

    public boolean playsEffect();

    public WaystoneTeleportContext setPlaysEffect(boolean var1);

    public boolean appliesModifiers();

    public WaystoneTeleportContext setAppliesModifiers(boolean var1);

    public Set<Identifier> getFlags();

    public WaystoneTeleportContext addFlag(Identifier var1);

    public WaystoneTeleportContext removeFlag(Identifier var1);

    default public WaystoneTeleportContext addFlags(Set<Identifier> flags) {
        for (Identifier flag : flags) {
            this.addFlag(flag);
        }
        return this;
    }

    default public boolean hasFlag(Identifier flag) {
        return this.getFlags().contains(flag);
    }
}

