/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.client.color.block.BalmBlockColorRegistrar;
import net.blay09.mods.balm.client.gui.screens.inventory.BalmMenuScreenRegistrar;
import net.blay09.mods.balm.client.model.geom.BalmModelLayerRegistrar;
import net.blay09.mods.balm.client.platform.module.BalmClientModule;
import net.blay09.mods.balm.client.renderer.block.model.BalmBlockStateModelRegistrar;
import net.blay09.mods.balm.client.renderer.blockentity.BalmBlockEntityRendererRegistrar;
import net.blay09.mods.balm.client.renderer.chunk.BalmBlockRenderTypeRegistrar;
import net.blay09.mods.waystones.client.InventoryButtonGuiHandler;
import net.blay09.mods.waystones.client.ModClientEventHandlers;
import net.blay09.mods.waystones.client.ModModels;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.ModScreens;
import net.blay09.mods.waystones.client.requirement.RequirementClientRegistry;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.store.EventfulWaystonesStore;
import net.blay09.mods.waystones.store.InMemoryWaystonesStore;
import net.blay09.mods.waystones.store.WaystonesStore;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.resources.Identifier;

public class WaystonesClient
implements BalmClientModule {
    private static final WaystonesStore waystonesStore = new EventfulWaystonesStore(new InMemoryWaystonesStore(List.of()));

    public Identifier getId() {
        return Identifier.fromNamespaceAndPath((String)"waystones", (String)"client");
    }

    public void registerBlockRenderTypes(BalmBlockRenderTypeRegistrar blockRenderTypes) {
        ModRenderers.initialize(blockRenderTypes);
    }

    public void registerModelLayers(BalmModelLayerRegistrar modelLayers) {
        ModRenderers.initialize(modelLayers);
    }

    public void registerBlockColors(BalmBlockColorRegistrar blockColors) {
        ModRenderers.initialize(blockColors);
    }

    public void registerBlockEntityRenderers(BalmBlockEntityRendererRegistrar blockEntityRenderers) {
        ModRenderers.initialize(blockEntityRenderers);
    }

    public void registerMenuScreens(BalmMenuScreenRegistrar screens) {
        ModScreens.initialize(screens);
    }

    public void registerBlockStateModels(BalmBlockStateModelRegistrar models) {
        ModModels.initialize(models);
    }

    public void initialize() {
        ModClientEventHandlers.initialize();
        InventoryButtonGuiHandler.initialize();
        RequirementClientRegistry.registerDefaults();
        Compat.isVivecraftInstalled = ClientBrandRetriever.getClientModName().toLowerCase(Locale.ENGLISH).contains("vivecraft");
    }

    public static WaystonesStore getWaystonesStore() {
        return waystonesStore;
    }
}

