/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class SortWaystoneButton
extends Button {
    private static final Identifier MOVE_UP_HIGHLIGHTED_SPRITE = Identifier.withDefaultNamespace((String)"server_list/move_up_highlighted");
    private static final Identifier MOVE_UP_SPRITE = Identifier.withDefaultNamespace((String)"server_list/move_up");
    private static final Identifier MOVE_DOWN_HIGHLIGHTED_SPRITE = Identifier.withDefaultNamespace((String)"server_list/move_down_highlighted");
    private static final Identifier MOVE_DOWN_SPRITE = Identifier.withDefaultNamespace((String)"server_list/move_down");
    private final int sortDir;
    private final int visibleRegionStart;
    private final int visibleRegionHeight;

    public SortWaystoneButton(int x, int y, int sortDir, int visibleRegionStart, int visibleRegionHeight, Button.OnPress pressable) {
        super(x, y, 11, 7, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
        this.sortDir = sortDir;
        this.visibleRegionStart = visibleRegionStart;
        this.visibleRegionHeight = visibleRegionHeight;
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (mouseY >= this.visibleRegionStart && mouseY < this.visibleRegionStart + this.visibleRegionHeight) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int renderY = this.getY() - (this.sortDir == 1 ? 20 : 5);
            int color = 0x40FFFFFF;
            if (this.active && this.isHovered) {
                color = -1;
            } else if (this.active) {
                color = -1056964609;
            }
            if (this.isHovered && this.active) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sortDir == 1 ? MOVE_DOWN_HIGHLIGHTED_SPRITE : MOVE_UP_HIGHLIGHTED_SPRITE, this.getX() - 5, renderY, 32, 32, color);
            } else {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sortDir == 1 ? MOVE_DOWN_SPRITE : MOVE_UP_SPRITE, this.getX() - 5, renderY, 32, 32, color);
            }
        }
    }
}

