/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.component.WaystoneReferenceComponent;
import net.blay09.mods.waystones.item.AbstractAttunedShardItem;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class CrumblingAttunedShardItem
extends AbstractAttunedShardItem {
    public CrumblingAttunedShardItem(Item.Properties properties) {
        super(properties.stacksTo(4));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        UUID attunedWaystoneId = Optional.ofNullable((WaystoneReferenceComponent)stack.get((DataComponentType)ModComponents.warpPlateAttunement.value())).map(WaystoneReferenceComponent::waystoneId).orElseGet(() -> (UUID)stack.get((DataComponentType)ModComponents.attunement.value()));
        if (attunedWaystoneId != null) {
            AbstractContainerMenu abstractContainerMenu;
            MutableComponent textComponent = Component.translatable((String)"tooltip.waystones.attuned_shard.attunement_crumbling");
            textComponent.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.ITALIC);
            Player player = Balm.safeClientAccess().getClientPlayer();
            if (player != null && (abstractContainerMenu = player.containerMenu) instanceof WaystoneModifierMenu) {
                WaystoneModifierMenu wpc = (WaystoneModifierMenu)abstractContainerMenu;
                if (!attunedWaystoneId.equals(wpc.getWaystone().getWaystoneUid())) {
                    list.accept((Component)textComponent);
                }
            } else {
                list.accept((Component)textComponent);
            }
        }
    }
}

