/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Random;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ScrollItemBase
extends Item {
    private static final Random random = new Random();

    public ScrollItemBase(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        if (WaystonesConfig.getActive().general.scrollUseTime <= 0 || Compat.isVivecraftInstalled) {
            return ItemUseAnimation.NONE;
        }
        return ItemUseAnimation.BOW;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isUsingItem() && !world.isClientSide()) {
            world.playSound(null, (Entity)player, SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 0.1f, 2.0f);
        }
        if (this.getUseDuration(itemStack, (LivingEntity)player) <= 0 || Compat.isVivecraftInstalled) {
            this.finishUsingItem(itemStack, world, (LivingEntity)player);
        } else {
            player.startUsingItem(hand);
        }
        return InteractionResult.SUCCESS;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack itemStack, int remainingTicks) {
        if (level.isClientSide()) {
            int i;
            int duration = this.getUseDuration(itemStack, entity);
            float progress = (float)(duration - remainingTicks) / (float)duration;
            int maxParticles = Math.max(4, (int)(progress * 48.0f));
            if (remainingTicks % 5 == 0) {
                for (i = 0; i < maxParticles; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, entity.getX() + (random.nextDouble() - 0.5) * 1.5, entity.getY() + random.nextDouble(), entity.getZ() + (random.nextDouble() - 0.5) * 1.5, 0.0, random.nextDouble(), 0.0);
                }
                if (progress >= 0.25f) {
                    for (i = 0; i < maxParticles; ++i) {
                        level.addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, entity.getX() + (random.nextDouble() - 0.5) * 1.5, entity.getY() + random.nextDouble(), entity.getZ() + (random.nextDouble() - 0.5) * 1.5, 0.0, random.nextDouble(), 0.0);
                    }
                }
                if (progress >= 0.5f) {
                    for (i = 0; i < maxParticles / 3; ++i) {
                        level.addParticle((ParticleOptions)ParticleTypes.WITCH, entity.getX() + (random.nextDouble() - 0.5) * 1.5, entity.getY() + 0.5 + random.nextDouble(), entity.getZ() + (random.nextDouble() - 0.5) * 1.5, 0.0, random.nextDouble(), 0.0);
                    }
                }
            }
            if (remainingTicks == 1) {
                for (i = 0; i < maxParticles; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.PORTAL, entity.getX() + (random.nextDouble() - 0.5) * 1.5, entity.getY() + random.nextDouble() + 1.0, entity.getZ() + (random.nextDouble() - 0.5) * 1.5, (random.nextDouble() - 0.5) * 0.0, random.nextDouble(), (random.nextDouble() - 0.5) * 0.0);
                }
            }
        }
    }
}

