/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.world.BalmMenuFactory;
import net.blay09.mods.balm.world.inventory.BalmMenuTypeRegistrar;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ModMenus {
    public static Holder<MenuType<WaystoneSelectionMenu>> waystoneSelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> warpScrollSelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> warpStoneSelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> portstoneSelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> inventorySelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> adminSelection;
    public static Holder<MenuType<WaystoneSelectionMenu>> sharestoneSelection;
    public static Holder<MenuType<WaystoneModifierMenu>> waystoneModifiers;
    public static Holder<MenuType<WaystoneEditMenu>> waystoneSettings;

    public static void initialize(BalmMenuTypeRegistrar menus) {
        waystoneSelection = menus.register("waystone_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.value()), data.fromWaystone(), windowId, data.waystones(), Collections.emptySet());
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
                return WaystoneSelectionMenu.STREAM_CODEC;
            }
        }).asHolder();
        warpScrollSelection = menus.register("warp_scroll_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, ItemInitiatedWaystoneMenuData>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, ItemInitiatedWaystoneMenuData data) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpScrollSelection.value()), null, windowId, data.waystones(), Collections.emptySet()).withWarpItem(data.itemStack());
            }

            public StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> getStreamCodec() {
                return ItemInitiatedWaystoneMenuData.STREAM_CODEC;
            }
        }).asHolder();
        warpStoneSelection = menus.register("warp_stone_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, ItemInitiatedWaystoneMenuData>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, ItemInitiatedWaystoneMenuData data) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpStoneSelection.value()), null, windowId, data.waystones(), Collections.emptySet()).withWarpItem(data.itemStack());
            }

            public StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> getStreamCodec() {
                return ItemInitiatedWaystoneMenuData.STREAM_CODEC;
            }
        }).asHolder();
        portstoneSelection = menus.register("portstone_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, List<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, List<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)portstoneSelection.value()), null, windowId, waystones, Set.of(TeleportFlags.PORTSTONE));
            }

            public StreamCodec<RegistryFriendlyByteBuf, List<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        }).asHolder();
        inventorySelection = menus.register("inventory_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, List<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, List<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)inventorySelection.value()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
            }

            public StreamCodec<RegistryFriendlyByteBuf, List<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        }).asHolder();
        adminSelection = menus.register("admin_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, List<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, List<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)adminSelection.value()), null, windowId, waystones, Set.of(TeleportFlags.ADMIN));
            }

            public StreamCodec<RegistryFriendlyByteBuf, List<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        }).asHolder();
        sharestoneSelection = menus.register("sharestone_selection", (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.value()), data.fromWaystone(), windowId, data.waystones(), Collections.emptySet());
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
                return WaystoneSelectionMenu.STREAM_CODEC;
            }
        }).asHolder();
        waystoneModifiers = menus.register("waystone_modifiers", (BalmMenuFactory)new BalmMenuFactory<WaystoneModifierMenu, Waystone>(){

            public WaystoneModifierMenu create(int windowId, Inventory inventory, Waystone waystone) {
                return new WaystoneModifierMenu(windowId, inventory, waystone);
            }

            public StreamCodec<RegistryFriendlyByteBuf, Waystone> getStreamCodec() {
                return WaystoneImpl.STREAM_CODEC;
            }
        }).asHolder();
        waystoneSettings = menus.register("waystone", (BalmMenuFactory)new BalmMenuFactory<WaystoneEditMenu, WaystoneEditMenu.Data>(){

            public WaystoneEditMenu create(int windowId, Inventory inventory, WaystoneEditMenu.Data data) {
                return new WaystoneEditMenu(windowId, data.waystone(), data.modifierCount(), data.error().orElse(null), data.visibilityOptions());
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneEditMenu.Data> getStreamCodec() {
                return WaystoneEditMenu.STREAM_CODEC;
            }
        }).asHolder();
    }

    public record ItemInitiatedWaystoneMenuData(List<Waystone> waystones, ItemStack itemStack) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> STREAM_CODEC = StreamCodec.composite(WaystoneImpl.LIST_STREAM_CODEC, ItemInitiatedWaystoneMenuData::waystones, (StreamCodec)ItemStack.STREAM_CODEC, ItemInitiatedWaystoneMenuData::itemStack, ItemInitiatedWaystoneMenuData::new);
    }
}

