/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.world.BalmMenuProvider;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class ServerboundInventoryButtonPacket
implements CustomPacketPayload {
    public static final ServerboundInventoryButtonPacket INSTANCE = new ServerboundInventoryButtonPacket();
    public static final CustomPacketPayload.Type<ServerboundInventoryButtonPacket> TYPE = new CustomPacketPayload.Type(Waystones.id("inventory_button"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundInventoryButtonPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private ServerboundInventoryButtonPacket() {
    }

    public static void handle(ServerPlayer player, ServerboundInventoryButtonPacket message) {
        Optional<Waystone> waystone;
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (!inventoryButtonMode.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.getAbilities().instabuild) {
            PlayerWaystoneManager.resetCooldowns((Player)player);
        }
        if ((waystone = PlayerWaystoneManager.getInventoryButtonTarget((Player)player)).isPresent()) {
            WaystonesAPI.createDefaultTeleportContext((Entity)player, waystone.get(), it -> it.addFlag(TeleportFlags.INVENTORY_BUTTON)).mapLeft(WaystonesAPI::tryTeleport);
        } else if (inventoryButtonMode.isReturnToAny()) {
            final ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getTargetsForInventoryButton(player));
            PlayerWaystoneManager.ensureSortingIndex((Player)player, waystones);
            BalmMenuProvider<List<Waystone>> containerProvider = new BalmMenuProvider<List<Waystone>>(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.waystones.waystone_selection");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.inventorySelection.value()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
                }

                public List<Waystone> getScreenOpeningData(ServerPlayer serverPlayer) {
                    return waystones;
                }

                public StreamCodec<RegistryFriendlyByteBuf, List<Waystone>> getScreenStreamCodec() {
                    return WaystoneImpl.LIST_STREAM_CODEC;
                }
            };
            Balm.networking().openMenu((Player)player, (MenuProvider)containerProvider);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

