/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.world.entity.ai.village.poi.BalmPoiTypeRegistrar;
import net.blay09.mods.balm.world.level.biome.BiomePredicate;
import net.blay09.mods.balm.world.level.block.DeferredBlock;
import net.blay09.mods.balm.world.level.levelgen.BalmWorldGen;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.tag.ModBiomeTags;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModWorldGen {
    private static final Identifier waystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"waystone");
    private static final Identifier mossyWaystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"mossy_waystone");
    private static final Identifier sandyWaystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"sandy_waystone");
    private static final Identifier blackstoneWaystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"blackstone_waystone");
    private static final Identifier deepslateWaystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"deepslate_waystone");
    private static final Identifier endStoneWaystone = Identifier.fromNamespaceAndPath((String)"waystones", (String)"end_stone_waystone");
    private static final Identifier villageWaystoneStructure = Identifier.fromNamespaceAndPath((String)"waystones", (String)"village/common/waystone");
    private static final Identifier desertVillageWaystoneStructure = Identifier.fromNamespaceAndPath((String)"waystones", (String)"village/desert/waystone");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)"empty"));
    public static Holder<PlacementModifierType<?>> waystonePlacement;

    public static void initializeFeatures(BalmRegistrar.Scoped<Feature<?>> registrar) {
        registrar.register(waystone.getPath(), id -> new WaystoneFeature());
    }

    public static void initializePlacementModifierTypes(BalmRegistrar.Scoped<PlacementModifierType<?>> registrar) {
        waystonePlacement = registrar.register("waystone", id -> () -> WaystonePlacement.CODEC);
    }

    public static void initializePoiTypes(BalmPoiTypeRegistrar registrar) {
        registrar.register("wild_waystone", () -> new PoiType(ModWorldGen.gatherWaystonesOfOrigin(WaystoneOrigin.WILDERNESS), 1, 1));
        registrar.register("village_waystone", () -> new PoiType(ModWorldGen.gatherWaystonesOfOrigin(WaystoneOrigin.VILLAGE), 1, 1));
    }

    public static void initialize(BalmWorldGen worldGen) {
        Balm.config().onConfigAvailable(WaystonesConfig.class, config -> {
            worldGen.modifyBiome(ModWorldGen.id("add_sandy_waystone"), ModWorldGen.matchesTag(ModBiomeTags.HAS_STRUCTURE_SANDY_WAYSTONE), (biome, builder) -> builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY)));
            worldGen.modifyBiome(ModWorldGen.id("add_mossy_waystone"), ModWorldGen.matchesTag(ModBiomeTags.HAS_STRUCTURE_MOSSY_WAYSTONE), (biome, builder) -> builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY)));
            worldGen.modifyBiome(ModWorldGen.id("add_blackstone_waystone"), ModWorldGen.matchesTag(ModBiomeTags.HAS_STRUCTURE_BLACKSTONE_WAYSTONE), (biome, builder) -> builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.BLACKSTONE)));
            worldGen.modifyBiome(ModWorldGen.id("add_end_stone_waystone"), ModWorldGen.matchesTag(ModBiomeTags.HAS_STRUCTURE_END_STONE_WAYSTONE), (biome, builder) -> builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.END_STONE)));
            worldGen.modifyBiome(ModWorldGen.id("add_waystone"), ModWorldGen.matchesTag(ModBiomeTags.HAS_STRUCTURE_WAYSTONE), (biome, builder) -> builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT)));
        });
        ServerLifecycleCallback.Starting.EVENT.register(server -> ModWorldGen.setupDynamicRegistries((RegistryAccess)server.registryAccess()));
    }

    private static Set<BlockState> gatherWaystonesOfOrigin(WaystoneOrigin origin) {
        List<DeferredBlock> sourceBlocks = List.of(ModBlocks.waystone, ModBlocks.sandyWaystone, ModBlocks.mossyWaystone, ModBlocks.blackstoneWaystone, ModBlocks.endStoneWaystone);
        return sourceBlocks.stream().flatMap(it -> it.asBlock().getStateDefinition().getPossibleStates().stream()).filter(it -> it.getValue((Property)WaystoneBlock.ORIGIN) == origin).collect(Collectors.toSet());
    }

    private static BiomePredicate matchesTag(TagKey<Biome> tag) {
        return biomeHolder -> biomeHolder.is(tag);
    }

    private static Identifier id(String name) {
        return Identifier.fromNamespaceAndPath((String)"waystones", (String)name);
    }

    private static ResourceKey<PlacedFeature> getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGen.wildWaystoneStyle;
        Identifier identifier = switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> mossyWaystone;
            case WorldGenStyle.SANDY -> sandyWaystone;
            case WorldGenStyle.BLACKSTONE -> blackstoneWaystone;
            case WorldGenStyle.DEEPSLATE -> deepslateWaystone;
            case WorldGenStyle.END_STONE -> endStoneWaystone;
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield sandyWaystone;
                    }
                    case MOSSY: {
                        yield mossyWaystone;
                    }
                    case BLACKSTONE: {
                        yield blackstoneWaystone;
                    }
                    case DEEPSLATE: {
                        yield deepslateWaystone;
                    }
                    case END_STONE: {
                        yield endStoneWaystone;
                    }
                }
                yield waystone;
            }
            default -> waystone;
        };
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (Identifier)identifier);
    }

    public static void setupDynamicRegistries(RegistryAccess registryAccess) {
        if (WaystonesConfig.getActive().worldGen.spawnInVillages != WaystonesConfig.VillageWaystoneGeneration.DISABLED) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(RegistryAccess registryAccess, String villagePiece, Identifier waystoneStructure, int weight) {
        StructureTemplatePool pool;
        Holder.Reference emptyProcessorList = registryAccess.lookupOrThrow(Registries.PROCESSOR_LIST).getOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        LegacySinglePoolElement piece = (LegacySinglePoolElement)StructurePoolElement.legacy((String)waystoneStructure.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        if (piece instanceof WaystoneStructurePoolElement) {
            WaystoneStructurePoolElement element = (WaystoneStructurePoolElement)piece;
            element.waystones$setIsWaystone(true);
        }
        if ((pool = (StructureTemplatePool)registryAccess.lookupOrThrow(Registries.TEMPLATE_POOL).getOptional(Identifier.withDefaultNamespace((String)villagePiece)).orElse(null)) != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<StructurePoolElement>)listOfPieces);
            ArrayList<Pair<StructurePoolElement, Integer>> listOfWeightedPieces = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

