/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.Objects;
import net.blay09.mods.balm.api.client.rendering.BalmRenderers;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.client.render.PortstoneModel;
import net.blay09.mods.waystones.client.render.PortstoneRenderer;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.client.render.SharestoneRenderer;
import net.blay09.mods.waystones.client.render.WaystoneModel;
import net.blay09.mods.waystones.client.render.WaystoneRenderer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ModRenderers {
    public static ModelLayerLocation portstoneModel;
    public static ModelLayerLocation sharestoneModel;
    public static ModelLayerLocation waystoneModel;

    public static void initialize(BalmRenderers renderers) {
        portstoneModel = renderers.registerModel(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"portstone"), () -> PortstoneModel.createLayer(CubeDeformation.NONE));
        sharestoneModel = renderers.registerModel(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"sharestone"), () -> SharestoneModel.createLayer(CubeDeformation.NONE));
        waystoneModel = renderers.registerModel(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"waystone"), () -> WaystoneModel.createLayer(CubeDeformation.NONE));
        renderers.registerBlockEntityRenderer(Waystones.id("waystone"), () -> ModBlockEntities.waystone.get(), WaystoneRenderer::new);
        renderers.registerBlockEntityRenderer(Waystones.id("sharestone"), () -> ModBlockEntities.sharestone.get(), SharestoneRenderer::new);
        renderers.registerBlockEntityRenderer(Waystones.id("portstone"), () -> ModBlockEntities.portstone.get(), PortstoneRenderer::new);
        renderers.registerBlockColorHandler(Waystones.id("warp_plate"), (state, view, pos, tintIndex) -> -3909955, () -> new Block[]{ModBlocks.warpPlate});
        renderers.registerBlockColorHandler(Waystones.id("sharestone"), (state, view, pos, tintIndex) -> Objects.requireNonNull(((SharestoneBlock)state.getBlock()).getColor()).getTextColor() | 0xFF000000, () -> ModBlocks.sharestones);
        renderers.registerBlockColorHandler(Waystones.id("portstone"), (state, view, pos, tintIndex) -> Objects.requireNonNull(((PortstoneBlock)state.getBlock()).getColor()).getTextColor() | 0xFF000000, () -> ModBlocks.portstones);
        renderers.setBlockRenderType(() -> ModBlocks.warpPlate, RenderType.cutout());
    }
}

