/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record ClientboundPlayerWaystoneCooldownsPacket(Map<ResourceLocation, Long> cooldowns) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundPlayerWaystoneCooldownsPacket> TYPE = new CustomPacketPayload.Type(Waystones.id("player_waystone_cooldowns"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerWaystoneCooldownsPacket> STREAM_CODEC = StreamCodec.of(ClientboundPlayerWaystoneCooldownsPacket::encode, ClientboundPlayerWaystoneCooldownsPacket::decode);

    public static void encode(FriendlyByteBuf buf, ClientboundPlayerWaystoneCooldownsPacket message) {
        buf.writeByte(message.cooldowns.size());
        for (Map.Entry<ResourceLocation, Long> entry : message.cooldowns.entrySet()) {
            buf.writeResourceLocation(entry.getKey());
            buf.writeLong(entry.getValue().longValue());
        }
    }

    public static ClientboundPlayerWaystoneCooldownsPacket decode(FriendlyByteBuf buf) {
        int size = buf.readByte();
        HashMap<ResourceLocation, Long> cooldowns = new HashMap<ResourceLocation, Long>(size);
        for (int i = 0; i < size; ++i) {
            cooldowns.put(buf.readResourceLocation(), buf.readLong());
        }
        return new ClientboundPlayerWaystoneCooldownsPacket(cooldowns);
    }

    public static void handle(Player player, ClientboundPlayerWaystoneCooldownsPacket message) {
        message.cooldowns.forEach((key, timestamp) -> PlayerWaystoneManager.setCooldownUntil(player, key, timestamp));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

