/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public record ServerboundRemoveWaystonePacket(UUID waystoneUid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundRemoveWaystonePacket> TYPE = new CustomPacketPayload.Type(Waystones.id("remove_waystone"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundRemoveWaystonePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ServerboundRemoveWaystonePacket::waystoneUid, ServerboundRemoveWaystonePacket::new);

    public static void handle(ServerPlayer player, ServerboundRemoveWaystonePacket message) {
        WaystoneProxy waystone = new WaystoneProxy(player.server, message.waystoneUid);
        PlayerWaystoneManager.deactivateWaystone((Player)player, waystone);
        if (player.getAbilities().instabuild) {
            Waystone backingWaystone;
            if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
                SavedDataWaystonesStore.get(player.server).removeWaystone(waystone);
            } else if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && (backingWaystone = waystone.getBackingWaystone()) instanceof MutableWaystone) {
                BlockState state;
                MutableWaystone mutableWaystone = (MutableWaystone)((Object)backingWaystone);
                mutableWaystone.setVisibility(WaystoneVisibility.ACTIVATION);
                ServerLevel targetWorld = Objects.requireNonNull(player.level().getServer()).getLevel(backingWaystone.getDimension());
                BlockPos pos = backingWaystone.getPos();
                BlockState blockState = state = targetWorld != null ? targetWorld.getBlockState(pos) : null;
                if (targetWorld == null || !(state.getBlock() instanceof WaystoneBlock)) {
                    SavedDataWaystonesStore.get(player.server).removeWaystone(backingWaystone);
                    PlayerWaystoneManager.removeKnownWaystone(player.server, backingWaystone);
                    WaystoneSyncManager.sendWaystoneRemovalToAll(player.server, backingWaystone, true);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

